/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.chain;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.Future;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.protocol.HttpContext;
import org.openrdf.http.object.chain.AsyncExecChain;
import org.openrdf.http.object.chain.HttpRequestChainInterceptor;
import org.openrdf.http.object.helpers.CompletedResponse;
import org.openrdf.http.object.helpers.ResponseCallback;

public class HttpRequestChainInterceptorExecChain
implements AsyncExecChain {
    private final AsyncExecChain delegate;
    private final List<HttpRequestChainInterceptor> interceptors = new ArrayList<HttpRequestChainInterceptor>();

    public HttpRequestChainInterceptorExecChain(AsyncExecChain delegate) {
        this.delegate = delegate;
        ClassLoader cl = this.getClass().getClassLoader();
        ServiceLoader<HttpRequestChainInterceptor> ld = ServiceLoader.load(HttpRequestChainInterceptor.class, cl);
        Iterator<HttpRequestChainInterceptor> iter = ld.iterator();
        while (iter.hasNext()) {
            this.interceptors.add(iter.next());
        }
    }

    @Override
    public Future<HttpResponse> execute(HttpHost host, final HttpRequest request, final HttpContext context, FutureCallback<HttpResponse> callback) {
        try {
            callback = new ResponseCallback(callback){

                @Override
                public void completed(HttpResponse result) {
                    try {
                        HttpRequestChainInterceptorExecChain.this.process(request, result, context);
                        super.completed(result);
                    }
                    catch (IOException ex) {
                        super.failed(ex);
                    }
                    catch (RuntimeException ex) {
                        super.failed(ex);
                    }
                    catch (HttpException ex) {
                        super.failed((Exception)((Object)ex));
                    }
                }
            };
            HttpResponse response = this.intercept(request, context);
            if (response != null) {
                return new CompletedResponse((FutureCallback<HttpResponse>)callback, response);
            }
        }
        catch (IOException ex) {
            return new CompletedResponse(callback, ex);
        }
        catch (HttpException ex) {
            return new CompletedResponse(callback, (Exception)((Object)ex));
        }
        catch (RuntimeException ex) {
            return new CompletedResponse(callback, ex);
        }
        return this.delegate.execute(host, request, context, callback);
    }

    private HttpResponse intercept(HttpRequest request, HttpContext context) throws HttpException, IOException {
        for (HttpRequestChainInterceptor interceptor : this.interceptors) {
            HttpResponse resp = interceptor.intercept(request, context);
            if (resp == null) continue;
            return resp;
        }
        return null;
    }

    void process(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        for (HttpRequestChainInterceptor interceptor : this.interceptors) {
            interceptor.process(request, response, context);
        }
    }
}

