/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.chain;

import java.util.Date;
import java.util.Enumeration;
import java.util.concurrent.Future;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.concurrent.BasicFuture;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.protocol.HttpContext;
import org.openrdf.http.object.chain.AsyncExecChain;
import org.openrdf.http.object.client.HttpUriResponse;
import org.openrdf.http.object.helpers.ObjectContext;
import org.openrdf.http.object.helpers.Request;
import org.openrdf.http.object.helpers.ResponseBuilder;
import org.openrdf.http.object.helpers.ResponseCallback;
import org.openrdf.http.object.util.HTTPDateFormat;

public class ModifiedSinceHandler
implements AsyncExecChain {
    private final AsyncExecChain delegate;
    private long reset = System.currentTimeMillis() / 1000L * 1000L;
    private HTTPDateFormat format = new HTTPDateFormat();

    public ModifiedSinceHandler(AsyncExecChain delegate) {
        this.delegate = delegate;
    }

    public void invalidate() {
        this.reset = System.currentTimeMillis() / 1000L * 1000L;
    }

    @Override
    public Future<HttpResponse> execute(HttpHost target, final HttpRequest request, final HttpContext context, FutureCallback<HttpResponse> callback) {
        HttpUriResponse resp;
        Header lastModified;
        callback = new ResponseCallback(callback){

            @Override
            public void completed(HttpResponse result) {
                try {
                    ModifiedSinceHandler.this.resetModified(request, result, context);
                    super.completed(result);
                }
                catch (RuntimeException ex) {
                    super.failed(ex);
                }
            }
        };
        HttpResponse head = ObjectContext.adapt(context).getDerivedFromHeadResponse();
        Request req = new Request(request, context);
        String method = req.getMethod();
        Header eTag = head == null ? null : head.getFirstHeader("ETag");
        Header header = lastModified = head == null ? null : head.getFirstHeader("Last-Modified");
        if (eTag == null && lastModified == null) {
            return this.delegate.execute(target, request, context, callback);
        }
        String tag = this.modifiedSince(req, eTag, lastModified);
        if ("GET".equals(method) || "HEAD".equals(method)) {
            if (tag == null) {
                return this.delegate.execute(target, request, context, callback);
            }
            resp = new ResponseBuilder(request, context).notModified();
        } else {
            if (tag == null) {
                return this.delegate.execute(target, request, context, callback);
            }
            resp = new ResponseBuilder(request, context).preconditionFailed();
        }
        if (tag.length() > 0) {
            resp.setHeader("ETag", tag);
        }
        BasicFuture future = new BasicFuture((FutureCallback)callback);
        future.completed((Object)resp);
        return future;
    }

    void resetModified(HttpRequest request, HttpResponse resp, HttpContext context) {
        boolean clientRequest = ObjectContext.adapt(context).getOriginalRequest() == null;
        Header lastHeader = resp.getLastHeader("Last-Modified");
        if (clientRequest && this.reset > 0L && lastHeader != null && this.reset > this.format.parseDate(lastHeader.getValue())) {
            resp.setHeader("Last-Modified", this.format.format(this.reset));
        }
    }

    private String modifiedSince(Request req, Header eTag, Header lastModifiedHeader) {
        long lastModified = Math.max(this.reset, this.getDateHeader(lastModifiedHeader));
        boolean notModified = false;
        try {
            if (lastModified > 0L) {
                long modified = req.getDateHeader("If-Modified-Since");
                boolean bl = notModified = modified > 0L;
                if (notModified && modified < lastModified) {
                    return null;
                }
            }
        }
        catch (IllegalArgumentException modified) {
            // empty catch block
        }
        Enumeration matchs = req.getHeaderEnumeration("If-None-Match");
        boolean mustMatch = matchs.hasMoreElements();
        if (eTag != null && mustMatch) {
            String match = null;
            while (matchs.hasMoreElements()) {
                match = (String)matchs.nextElement();
                if (!this.match(eTag.getValue(), match)) continue;
                return match;
            }
        }
        if (!notModified || mustMatch) {
            return null;
        }
        return "";
    }

    private boolean match(String tag, String match) {
        if (tag == null) {
            return false;
        }
        if ("*".equals(match)) {
            return true;
        }
        if (match.startsWith("W/") && !tag.startsWith("W/")) {
            match = match.substring(2);
        }
        if (match.equals(tag)) {
            return true;
        }
        int md = match.indexOf(45);
        int td = tag.indexOf(45);
        if (td >= 0 && md >= 0) {
            return false;
        }
        if (md < 0) {
            md = match.lastIndexOf(34);
        }
        if (td < 0) {
            td = tag.lastIndexOf(34);
        }
        int mq = match.indexOf(34);
        int tq = tag.indexOf(34);
        if (mq < 0 || tq < 0 || md < 0 || td < 0) {
            return false;
        }
        return match.substring(mq, md).equals(tag.substring(tq, td));
    }

    public long getDateHeader(Header header) {
        if (header == null) {
            return -1L;
        }
        Date date = DateUtils.parseDate((String)header.getValue());
        return date != null ? date.getTime() : -1L;
    }
}

