/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.chain;

import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.execchain.ClientExecChain;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.protocol.HttpContext;
import org.openrdf.http.object.client.HttpUriResponse;
import org.openrdf.http.object.helpers.Request;

public class NotFoundHandler
implements ClientExecChain {
    private final ClientExecChain delegate;

    public NotFoundHandler(ClientExecChain delegate) {
        this.delegate = delegate;
    }

    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        CloseableHttpResponse rb = this.delegate.execute(route, request, context, execAware);
        String method = request.getRequestLine().getMethod();
        int status = rb.getStatusLine().getStatusCode();
        if ((200 == status || 203 == status || 204 == status) && "GET".equals(method) && rb.getEntity() == null) {
            BasicHttpResponse resp = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 404, rb.getStatusLine().getReasonPhrase());
            for (Header hd : rb.getAllHeaders()) {
                resp.addHeader(hd);
            }
            rb.close();
            String url = new Request((HttpRequest)request, (HttpContext)context).getRequestURL();
            return new HttpUriResponse(url, (HttpResponse)resp);
        }
        return rb;
    }
}

