/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.chain;

import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Future;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.BasicFuture;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.protocol.HttpContext;
import org.openrdf.http.object.chain.AsyncExecChain;
import org.openrdf.http.object.client.HttpUriResponse;
import org.openrdf.http.object.helpers.ObjectContext;
import org.openrdf.http.object.helpers.Request;
import org.openrdf.http.object.helpers.ResourceTarget;
import org.openrdf.http.object.helpers.ResponseBuilder;
import org.openrdf.http.object.helpers.ResponseCallback;

public class OptionsHandler
implements AsyncExecChain {
    private static final String REQUEST_METHOD = "Access-Control-Request-Method";
    private static final Set<String> ALLOW_HEADERS = new TreeSet<String>(Arrays.asList("Authorization", "Cache-Control", "Location", "Range", "Accept", "Accept-Charset", "Accept-Encoding", "Accept-Language", "Content-Encoding", "Content-Language", "Content-Length", "Content-Location", "Content-MD5", "Content-Type", "If-Match", "If-Modified-Since", "If-None-Match", "If-Range", "If-Unmodified-Since"));
    private final AsyncExecChain delegate;

    public OptionsHandler(AsyncExecChain delegate) {
        this.delegate = delegate;
    }

    @Override
    public Future<HttpResponse> execute(HttpHost target, HttpRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
        final ResourceTarget trans = ObjectContext.adapt(context).getResourceTarget();
        final Request req = new Request(request, context);
        final String m = req.getMethod();
        if ("OPTIONS".equals(m) && trans.getHandlerMethod(request) == null) {
            HttpUriResponse rb = new ResponseBuilder(request, context).noContent();
            this.addPreflightHeaders(trans, req, (HttpResponse)rb);
            this.addDiscoveryHeaders(trans, req, (HttpResponse)rb);
            BasicFuture future = new BasicFuture(callback);
            future.completed((Object)rb);
            return future;
        }
        return this.delegate.execute(target, request, context, new ResponseCallback(callback){

            @Override
            public void completed(HttpResponse result) {
                try {
                    if (result != null) {
                        int status = result.getStatusLine().getStatusCode();
                        if ("GET".equals(m) || "HEAD".equals(m) || status >= 400) {
                            OptionsHandler.this.addDiscoveryHeaders(trans, req, result);
                        } else if ("OPTIONS".equals(m)) {
                            OptionsHandler.this.addPreflightHeaders(trans, req, result);
                            OptionsHandler.this.addDiscoveryHeaders(trans, req, result);
                        }
                    }
                    super.completed(result);
                }
                catch (RuntimeException ex) {
                    super.failed(ex);
                }
            }
        });
    }

    void addDiscoveryHeaders(ResourceTarget trans, Request request, HttpResponse rb) {
        String acceptPatch;
        String acceptPost;
        StringBuilder sb = new StringBuilder();
        sb.append("OPTIONS");
        for (String method : trans.getAllowedMethods(request.getRequestURL())) {
            sb.append(", ").append(method);
        }
        if (!rb.containsHeader("Allow")) {
            rb.addHeader("Allow", sb.toString());
        }
        if ((acceptPost = trans.getAccept("POST", request.getRequestURL())) != null && acceptPost.length() > 0 && !rb.containsHeader("Accept-Post")) {
            rb.addHeader("Accept-Post", acceptPost);
        }
        if ((acceptPatch = trans.getAccept("PATCH", request.getRequestURL())) != null && acceptPatch.length() > 0 && !rb.containsHeader("Accept-Patch")) {
            rb.addHeader("Accept-Patch", acceptPatch);
        }
    }

    void addPreflightHeaders(ResourceTarget trans, Request req, HttpResponse rb) {
        Header m = req.getFirstHeader(REQUEST_METHOD);
        if (!rb.containsHeader("Access-Control-Allow-Methods")) {
            if (m == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("OPTIONS");
                for (String method : trans.getAllowedMethods(req.getRequestURL())) {
                    sb.append(", ").append(method);
                }
                rb.addHeader("Access-Control-Allow-Methods", sb.toString());
            } else {
                rb.addHeader("Access-Control-Allow-Methods", m.getValue());
            }
        }
        if (!rb.containsHeader("Access-Control-Allow-Headers")) {
            StringBuilder headers = new StringBuilder();
            for (String header : ALLOW_HEADERS) {
                if (headers.length() > 0) {
                    headers.append(",");
                }
                headers.append(header);
            }
            String method = m == null ? null : m.getValue();
            String url = req.getRequestURL();
            for (String header : trans.getAllowedHeaders(method, url)) {
                if (ALLOW_HEADERS.contains(header)) continue;
                headers.append(",");
                headers.append(header);
            }
            rb.addHeader("Access-Control-Allow-Headers", headers.toString());
        }
    }
}

