/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.chain;

import java.util.concurrent.Future;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpDateGenerator;
import org.openrdf.http.object.chain.AsyncExecChain;
import org.openrdf.http.object.client.HttpUriResponse;
import org.openrdf.http.object.helpers.CompletedResponse;

public class PingOptionsHandler
implements AsyncExecChain {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();
    private final AsyncExecChain delegate;

    public PingOptionsHandler(AsyncExecChain delegate) {
        this.delegate = delegate;
    }

    @Override
    public Future<HttpResponse> execute(HttpHost target, HttpRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
        RequestLine line = request.getRequestLine();
        if ("OPTIONS".equals(request.getRequestLine().getMethod()) && "*".equals(line.getUri())) {
            HttpVersion ver = HttpVersion.HTTP_1_1;
            BasicHttpResponse resp = new BasicHttpResponse((ProtocolVersion)ver, 204, "No Content");
            resp.setHeader("Date", DATE_GENERATOR.getCurrentDate());
            resp.setHeader("Allow", "OPTIONS, GET, HEAD, PUT, DELETE");
            return new CompletedResponse(callback, (HttpResponse)new HttpUriResponse("*", (HttpResponse)resp));
        }
        return this.delegate.execute(target, request, context, callback);
    }
}

