/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.chain;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.execchain.ClientExecChain;
import org.apache.http.protocol.HttpContext;
import org.openrdf.http.object.chain.AsyncExecChain;
import org.openrdf.http.object.chain.BlockingExecChain;
import org.openrdf.http.object.helpers.CompletedResponse;
import org.openrdf.http.object.helpers.StagedFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledExecChain
implements AsyncExecChain {
    final Logger logger = LoggerFactory.getLogger(PooledExecChain.class);
    final AsyncExecChain delegate;
    private final ExecutorService executor;

    public PooledExecChain(ClientExecChain delegate, ExecutorService executor) {
        this(new BlockingExecChain(delegate), executor);
    }

    public PooledExecChain(AsyncExecChain delegate, ExecutorService executor) {
        this.delegate = delegate;
        this.executor = executor;
    }

    @Override
    public Future<HttpResponse> execute(final HttpHost target, final HttpRequest request, final HttpContext context, FutureCallback<HttpResponse> callback) {
        try {
            final StagedFuture future = new StagedFuture(callback);
            Future<?> first = this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (future.isCancelled()) {
                            future.cancelled();
                        } else {
                            future.addStage(PooledExecChain.this.delegate.execute(target, request, context, future));
                        }
                    }
                    catch (RuntimeException ex) {
                        future.failed(ex);
                    }
                    catch (Error ex) {
                        PooledExecChain.this.logger.error(ex.toString(), (Throwable)ex);
                        future.cancelled();
                        throw ex;
                    }
                }
            });
            future.addStage(first);
            return future;
        }
        catch (RejectedExecutionException e) {
            CompletedResponse future = new CompletedResponse(callback);
            future.cancel();
            return future;
        }
    }
}

