/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.chain;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.cache.ResourceFactory;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.execchain.ClientExecChain;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.openrdf.http.object.chain.AccessLog;
import org.openrdf.http.object.chain.AsyncExecChain;
import org.openrdf.http.object.chain.CacheHandler;
import org.openrdf.http.object.chain.ContentHeadersFilter;
import org.openrdf.http.object.chain.ContentPeekHandler;
import org.openrdf.http.object.chain.DerivedFromHeadFilter;
import org.openrdf.http.object.chain.ExpectContinueHandler;
import org.openrdf.http.object.chain.GETHeadResponseFilter;
import org.openrdf.http.object.chain.GUnzipFilter;
import org.openrdf.http.object.chain.GZipFilter;
import org.openrdf.http.object.chain.HttpRequestChainInterceptorExecChain;
import org.openrdf.http.object.chain.InvokeHandler;
import org.openrdf.http.object.chain.ModifiedSinceHandler;
import org.openrdf.http.object.chain.NotFoundHandler;
import org.openrdf.http.object.chain.OptionsHandler;
import org.openrdf.http.object.chain.PingOptionsHandler;
import org.openrdf.http.object.chain.PooledExecChain;
import org.openrdf.http.object.chain.ResponseExceptionHandler;
import org.openrdf.http.object.chain.SecureChannelFilter;
import org.openrdf.http.object.chain.TransactionHandler;
import org.openrdf.http.object.chain.UnmodifiedSinceHandler;
import org.openrdf.http.object.client.HttpUriResponse;
import org.openrdf.http.object.concurrent.ManagedExecutors;
import org.openrdf.http.object.exceptions.BadGateway;
import org.openrdf.http.object.exceptions.GatewayTimeout;
import org.openrdf.http.object.exceptions.ResponseException;
import org.openrdf.http.object.helpers.ObjectContext;
import org.openrdf.http.object.helpers.ResponseBuilder;
import org.openrdf.http.object.util.InlineExecutorService;
import org.openrdf.repository.object.ObjectRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestExecChain
implements AsyncExecChain,
ClientExecChain {
    private static final int MAX_QUEUE_SIZE = 32;
    final Logger logger = LoggerFactory.getLogger(RequestExecChain.class);
    private final ThreadLocal<Boolean> foreground = new ThreadLocal();
    private final ExecutorService triaging = new InlineExecutorService(this.foreground, ManagedExecutors.getInstance().newAntiDeadlockThreadPool(new ArrayBlockingQueue<Runnable>(32), "HttpTriaging"));
    private final ExecutorService handling = new InlineExecutorService(this.foreground, ManagedExecutors.getInstance().newAntiDeadlockThreadPool(new ArrayBlockingQueue<Runnable>(32), "HttpHandling"));
    private final ExecutorService closing = new InlineExecutorService(this.foreground, ManagedExecutors.getInstance().newFixedThreadPool(1, "HttpTransactionClosing"));
    private final TransactionHandler transaction;
    final CacheHandler cache;
    private final AsyncExecChain chain;
    final ModifiedSinceHandler remoteCache;

    public RequestExecChain() {
        this(null);
    }

    public RequestExecChain(ResourceFactory factory) {
        Object handler = new InvokeHandler();
        handler = new ContentPeekHandler((ClientExecChain)handler);
        handler = new NotFoundHandler((ClientExecChain)handler);
        AsyncExecChain filter = new PooledExecChain((ClientExecChain)handler, this.handling);
        filter = new GETHeadResponseFilter(filter);
        filter = new ResponseExceptionHandler(filter);
        filter = new ExpectContinueHandler(filter);
        filter = new OptionsHandler(filter);
        filter = new HttpRequestChainInterceptorExecChain(filter);
        filter = new ContentHeadersFilter(filter);
        this.remoteCache = new ModifiedSinceHandler(filter);
        filter = this.remoteCache;
        filter = new UnmodifiedSinceHandler(filter);
        filter = new DerivedFromHeadFilter(filter);
        this.transaction = new TransactionHandler(filter, this.closing);
        filter = this.transaction;
        filter = new GZipFilter(filter);
        filter = new PooledExecChain(filter, this.triaging);
        if (factory == null) {
            this.cache = null;
        } else {
            this.cache = new CacheHandler(filter, factory, this.getDefaultCacheConfig());
            filter = this.cache;
        }
        filter = new GUnzipFilter(filter);
        filter = new PingOptionsHandler(filter);
        filter = new SecureChannelFilter(filter);
        filter = new AccessLog(filter);
        this.chain = filter;
    }

    public void addRepository(String prefix, ObjectRepository repository) {
        this.transaction.addRepository(prefix, repository);
    }

    public void removeRepository(String prefix) {
        this.transaction.removeRepository(prefix);
    }

    public Collection<String> getRepositoryPrefixes() {
        return this.transaction.getRepositoryPrefixes();
    }

    public ObjectRepository getRepository(String prefix) {
        return this.transaction.getRepository(prefix);
    }

    public void removeAllRepositories() {
        this.transaction.removeAllRepositories();
    }

    public void resetCache() {
        ManagedExecutors.getInstance().getTimeoutThreadPool().execute(new Runnable(){

            public String toString() {
                return "reset cache";
            }

            @Override
            public void run() {
                RequestExecChain.this.resetCacheNow();
            }
        });
    }

    public void resetCacheNow() {
        try {
            this.logger.info("Resetting cache");
            if (this.cache != null) {
                this.cache.reset();
            }
            this.remoteCache.invalidate();
        }
        catch (Error e) {
            this.logger.error(e.toString(), (Throwable)e);
        }
        catch (RuntimeException e) {
            this.logger.error(e.toString(), (Throwable)e);
        }
        finally {
            System.gc();
            System.runFinalization();
            this.logger.debug("Cache reset");
        }
    }

    public boolean isShutdown() {
        return this.handling.isShutdown() || this.triaging.isShutdown() || this.closing.isShutdown();
    }

    public void shutdown() {
        this.triaging.shutdown();
        this.handling.shutdown();
        this.closing.shutdown();
    }

    public boolean isTerminated() {
        return this.handling.isTerminated() && this.triaging.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.triaging.awaitTermination(timeout, unit) && this.handling.awaitTermination(timeout, unit);
    }

    @Override
    public Future<HttpResponse> execute(HttpHost target, HttpRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
        ObjectContext cc = ObjectContext.adapt((HttpContext)new BasicHttpContext(context));
        return this.chain.execute(target, request, cc, callback);
    }

    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        HttpUriResponse response = null;
        Boolean previously = this.foreground.get();
        try {
            String systemId;
            if (previously == null) {
                this.foreground.set(true);
            }
            HttpHost target = route.getTargetHost();
            ObjectContext cc = ObjectContext.adapt((HttpContext)new BasicHttpContext((HttpContext)context));
            try {
                response = this.chain.execute(target, (HttpRequest)request, cc, new FutureCallback<HttpResponse>(){

                    public void failed(Exception ex) {
                        if (ex instanceof RuntimeException) {
                            throw (RuntimeException)ex;
                        }
                        throw new BadGateway(ex);
                    }

                    public void completed(HttpResponse result) {
                    }

                    public void cancelled() {
                    }
                }).get();
            }
            catch (InterruptedException ex) {
                this.logger.error(ex.toString(), (Throwable)ex);
                response = new ResponseBuilder((HttpRequest)request, cc).exception(new GatewayTimeout(ex));
            }
            catch (ExecutionException e) {
                Throwable ex = e.getCause();
                this.logger.error(ex.toString(), ex);
                if (ex instanceof Error) {
                    throw (Error)ex;
                }
                response = ex instanceof ResponseException ? new ResponseBuilder((HttpRequest)request, cc).exception((ResponseException)ex) : new ResponseBuilder((HttpRequest)request, cc).exception(new BadGateway(ex));
            }
            catch (ResponseException ex) {
                response = new ResponseBuilder((HttpRequest)request, cc).exception(ex);
            }
            catch (RuntimeException ex) {
                response = new ResponseBuilder((HttpRequest)request, cc).exception(new BadGateway(ex));
            }
            if (response == null) {
                response = new ResponseBuilder((HttpRequest)request, cc).exception(new BadGateway());
            }
            if (response instanceof CloseableHttpResponse) {
                CloseableHttpResponse ex = response;
                return ex;
            }
            String uri = request.getRequestLine().getUri();
            if (uri.startsWith("/")) {
                URI net = URI.create(uri);
                URI rewriten = URIUtils.rewriteURI((URI)net, (HttpHost)target, (boolean)true);
                systemId = rewriten.toASCIIString();
            } else {
                systemId = uri;
            }
            HttpUriResponse httpUriResponse = new HttpUriResponse(systemId, (HttpResponse)response);
            return httpUriResponse;
        }
        catch (URISyntaxException e) {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
            throw new ClientProtocolException((Throwable)e);
        }
        finally {
            if (previously == null) {
                this.foreground.remove();
            }
        }
    }

    private CacheConfig getDefaultCacheConfig() {
        return CacheConfig.custom().setSharedCache(true).setAllow303Caching(true).setWeakETagOnPutDeleteAllowed(true).setHeuristicCachingEnabled(true).setHeuristicDefaultLifetime(86400L).setMaxObjectSize(0x100000L).build();
    }
}

