/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.chain;

import java.util.Set;
import java.util.concurrent.Future;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.protocol.HttpContext;
import org.openrdf.http.object.chain.AsyncExecChain;
import org.openrdf.http.object.client.HttpUriResponse;
import org.openrdf.http.object.exceptions.InternalServerError;
import org.openrdf.http.object.exceptions.ResponseException;
import org.openrdf.http.object.helpers.CompletedResponse;
import org.openrdf.http.object.helpers.ObjectContext;
import org.openrdf.http.object.helpers.Request;
import org.openrdf.http.object.helpers.ResourceTarget;
import org.openrdf.http.object.helpers.ResponseBuilder;
import org.openrdf.http.object.helpers.ResponseCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseExceptionHandler
implements AsyncExecChain {
    final Logger logger = LoggerFactory.getLogger(ResponseExceptionHandler.class);
    private final AsyncExecChain delegate;

    public ResponseExceptionHandler(AsyncExecChain delegate) {
        this.delegate = delegate;
    }

    @Override
    public Future<HttpResponse> execute(HttpHost target, final HttpRequest request, final HttpContext context, FutureCallback<HttpResponse> callback) {
        callback = new ResponseCallback(callback){

            @Override
            public void failed(Exception ex) {
                try {
                    throw ex;
                }
                catch (ResponseException e) {
                    if (e.getStatusCode() < 500) {
                        ResponseExceptionHandler.this.logger.warn(e.getDetailMessage());
                    } else {
                        ResponseExceptionHandler.this.logger.error(e.getDetailMessage());
                    }
                    super.completed((HttpResponse)ResponseExceptionHandler.this.handle(request, context, e));
                }
                catch (Exception e) {
                    String uri = request.getRequestLine().getUri();
                    ResponseExceptionHandler.this.logger.error("Internal Server Error while responding to " + uri, (Throwable)e);
                    super.completed((HttpResponse)ResponseExceptionHandler.this.handle(request, context, new InternalServerError(e)));
                }
            }
        };
        try {
            return this.delegate.execute(target, request, context, callback);
        }
        catch (Exception ex) {
            return new CompletedResponse((FutureCallback<HttpResponse>)callback, ex);
        }
    }

    HttpUriResponse handle(HttpRequest request, HttpContext context, ResponseException e) {
        String url = new Request(request, context).getRequestURL();
        ResourceTarget trans = ObjectContext.adapt(context).getResourceTarget();
        HttpUriResponse resp = new ResponseBuilder(request, context).exception(e);
        if (trans == null || trans.getAllowedMethods(url).isEmpty()) {
            return resp;
        }
        Set<String> allowed = trans.getAllowedMethods(url);
        StringBuilder sb = new StringBuilder();
        for (String method : allowed) {
            sb.append(method).append(",");
        }
        String allow = sb.substring(0, sb.length() - 1);
        resp.addHeader("Allow", allow);
        return resp;
    }
}

