/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.chain;

import java.nio.charset.Charset;
import java.util.concurrent.Future;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.protocol.HttpContext;
import org.openrdf.http.object.chain.AsyncExecChain;
import org.openrdf.http.object.helpers.CompletedResponse;
import org.openrdf.http.object.helpers.ObjectContext;
import org.openrdf.http.object.helpers.Request;

public class SecureChannelFilter
implements AsyncExecChain {
    private final AsyncExecChain delegate;

    public SecureChannelFilter(AsyncExecChain delegate) {
        this.delegate = delegate;
    }

    @Override
    public Future<HttpResponse> execute(HttpHost target, HttpRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
        String scheme = new Request(request, context).getScheme();
        String protocol = ObjectContext.adapt(context).getProtocolScheme();
        if ("https".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(protocol)) {
            return new CompletedResponse(callback, (HttpResponse)this.insecure());
        }
        return this.delegate.execute(target, request, context, callback);
    }

    private BasicHttpResponse insecure() {
        String msg = "Cannot request secure resource over insecure channel";
        BasicHttpResponse resp = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 400, msg);
        resp.setEntity((HttpEntity)new StringEntity(msg, Charset.forName("UTF-8")));
        return resp;
    }
}

