/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.chain;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;

public class ServerNameFilter
implements HttpResponseInterceptor {
    private static final String PROTOCOL = "1.1";
    private final String HOSTNAME = this.getLocalHostName();
    private String name;
    private String via;
    private Integer port;

    public ServerNameFilter(String name) {
        this.setServerName(name);
    }

    public String getServerName() {
        return this.name;
    }

    public void setServerName(String name) {
        this.name = name;
        this.setVia();
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
        this.setVia();
    }

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        if (this.name != null) {
            if (response.containsHeader("Server")) {
                response.addHeader("Via", this.getVia());
            } else {
                response.setHeader("Server", this.name);
            }
        }
    }

    private synchronized String getVia() {
        return this.via;
    }

    private synchronized void setVia() {
        StringBuilder sb = new StringBuilder();
        sb.append(PROTOCOL).append(" ").append(this.HOSTNAME);
        if (this.port != null && this.port != 80 && this.port != 443) {
            sb.append(":").append(this.port);
        }
        sb.append(" (").append(this.name).append(")");
        this.via = sb.toString();
    }

    private String getLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName().toLowerCase();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }
}

