/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.chain;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.protocol.HttpContext;
import org.openrdf.OpenRDFException;
import org.openrdf.http.object.chain.AsyncExecChain;
import org.openrdf.http.object.client.CloseableEntity;
import org.openrdf.http.object.client.HttpUriResponse;
import org.openrdf.http.object.exceptions.InternalServerError;
import org.openrdf.http.object.exceptions.ServiceUnavailable;
import org.openrdf.http.object.helpers.CompletedResponse;
import org.openrdf.http.object.helpers.ObjectContext;
import org.openrdf.http.object.helpers.Request;
import org.openrdf.http.object.helpers.ResourceTarget;
import org.openrdf.http.object.helpers.ResourceTargetFactory;
import org.openrdf.http.object.helpers.ResponseBuilder;
import org.openrdf.http.object.helpers.ResponseCallback;
import org.openrdf.http.object.io.ChannelUtil;
import org.openrdf.http.object.util.PrefixMap;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.QueryLanguage;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.object.ObjectConnection;
import org.openrdf.repository.object.ObjectQuery;
import org.openrdf.repository.object.ObjectRepository;
import org.openrdf.repository.object.RDFObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionHandler
implements AsyncExecChain {
    private static final int ONE_PACKET = 1024;
    private final Logger logger = LoggerFactory.getLogger(ResourceTarget.class);
    private final PrefixMap<ObjectRepository> repositories = new PrefixMap();
    private final ResourceTargetFactory factory = new ResourceTargetFactory();
    private final AsyncExecChain handler;
    final Executor executor;

    public TransactionHandler(AsyncExecChain handler, Executor executor) {
        this.handler = handler;
        this.executor = executor;
    }

    public synchronized void addRepository(String prefix, ObjectRepository repository) {
        this.repositories.put(prefix, repository);
    }

    public synchronized void removeRepository(String prefix) {
        this.repositories.remove(prefix);
    }

    public synchronized Collection<String> getRepositoryPrefixes() {
        return new ArrayList<String>(this.repositories.keySet());
    }

    public synchronized ObjectRepository getRepository(String prefix) {
        return this.repositories.getClosest(prefix);
    }

    public synchronized void removeAllRepositories() {
        this.repositories.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<HttpResponse> execute(HttpHost target, HttpRequest request, HttpContext ctx, FutureCallback<HttpResponse> callback) {
        Request req = new Request(request, ctx);
        ObjectRepository repo = this.getRepository(req.getRequestURL());
        if (repo == null || !repo.isInitialized()) {
            return this.notSetup(req, ctx, callback);
        }
        final ObjectContext context = ObjectContext.adapt(ctx);
        final ObjectConnection con = repo.getConnection();
        boolean success = false;
        try {
            con.begin();
            RDFObject object = this.getRequestedObject(con, req.getIRI());
            ResourceTarget op = this.factory.createResourceTarget(object, context);
            context.setResourceTarget(op);
            Future<HttpResponse> future = this.handler.execute(target, request, context, new ResponseCallback(callback){

                @Override
                public void completed(HttpResponse result) {
                    try {
                        TransactionHandler.this.createSafeHttpEntity(result, con);
                        super.completed(result);
                    }
                    catch (RepositoryException ex) {
                        this.failed((Exception)((Object)ex));
                    }
                    catch (IOException ex) {
                        this.failed(ex);
                    }
                    catch (RuntimeException ex) {
                        this.failed(ex);
                    }
                    finally {
                        context.setResourceTarget(null);
                    }
                }

                @Override
                public void failed(Exception ex) {
                    TransactionHandler.this.endTransaction(con);
                    context.setResourceTarget(null);
                    super.failed(ex);
                }

                @Override
                public void cancelled() {
                    TransactionHandler.this.endTransaction(con);
                    context.setResourceTarget(null);
                    super.cancelled();
                }
            });
            success = true;
            Future<HttpResponse> future2 = future;
            if (!success) {
                this.endTransaction(con);
            }
            return future2;
        }
        catch (Throwable throwable) {
            try {
                if (!success) {
                    this.endTransaction(con);
                }
                throw throwable;
            }
            catch (OpenRDFException ex) {
                throw new InternalServerError(ex);
            }
        }
    }

    private RDFObject getRequestedObject(ObjectConnection con, String iri) throws OpenRDFException {
        int start = iri.indexOf("://") + 3;
        StringBuilder sparql = new StringBuilder();
        int i = iri.length() - 1;
        while (i > start) {
            if (sparql.length() == 0) {
                sparql.append("SELECT ?resource {\n{\n");
            } else {
                sparql.append("} UNION {\n");
            }
            sparql.append("BIND($p").append(i).append(" AS ?resource)\n");
            sparql.append("FILTER EXISTS { ?resource a ?type }\n");
            i = iri.lastIndexOf(47, i - 1);
        }
        if (sparql.length() == 0) {
            return (RDFObject)con.getObject(RDFObject.class, iri);
        }
        sparql.append("}} ORDER BY desc(?resource) LIMIT 1");
        ValueFactory vf = con.getValueFactory();
        ObjectQuery qry = con.prepareObjectQuery(QueryLanguage.SPARQL, sparql.toString());
        int i2 = iri.length() - 1;
        while (i2 > start) {
            String path = iri.substring(0, i2 + 1);
            qry.setBinding("p" + i2, (Value)vf.createURI(path));
            i2 = iri.lastIndexOf(47, i2 - 1);
        }
        RDFObject result = (RDFObject)qry.evaluate(RDFObject.class).next();
        if (result == null) {
            return (RDFObject)con.getObject(RDFObject.class, iri);
        }
        return result;
    }

    private synchronized Future<HttpResponse> notSetup(Request request, HttpContext ctx, FutureCallback<HttpResponse> callback) {
        String msg = "No origins are configured";
        if (!this.repositories.isEmpty()) {
            String origin = request.getOrigin();
            String closest = this.closest(origin, this.repositories.keySet());
            msg = "Origin " + origin + " is not configured, perhaps you wanted " + closest;
        }
        this.logger.warn(msg);
        ResponseBuilder rb = new ResponseBuilder((HttpRequest)request, ctx);
        HttpUriResponse resp = rb.exception(new ServiceUnavailable(msg));
        return new CompletedResponse(callback, (HttpResponse)resp);
    }

    private String closest(String origin, Set<String> origins) {
        Set<Character> base = this.toSet(origin.toCharArray());
        String closest = null;
        Set<Character> common = null;
        for (String o : origins) {
            Set<Character> set = this.toSet(o.toCharArray());
            set.retainAll(base);
            if (common != null && set.size() <= common.size()) continue;
            common = set;
            closest = o;
        }
        return closest;
    }

    private Set<Character> toSet(char[] charArray) {
        HashSet<Character> set = new HashSet<Character>(charArray.length);
        for (int i = 0; i < charArray.length; ++i) {
            set.add(Character.valueOf(charArray[i]));
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createSafeHttpEntity(HttpResponse resp, ObjectConnection con) throws IOException, RepositoryException {
        boolean endNow = true;
        try {
            if (resp.getEntity() != null) {
                int code = resp.getStatusLine().getStatusCode();
                HttpEntity entity = resp.getEntity();
                long length = entity.getContentLength();
                if (!(code != 200 && code != 203 || length >= 0L && length <= 1024L)) {
                    resp.setEntity((HttpEntity)this.endEntity(entity, con));
                    endNow = false;
                } else {
                    resp.setEntity((HttpEntity)this.copyEntity(entity, (int)length));
                    endNow = true;
                }
            } else {
                resp.setHeader("Content-Length", "0");
                endNow = true;
            }
        }
        finally {
            if (endNow) {
                this.endTransaction(con);
            }
        }
    }

    public void endTransaction(ObjectConnection con) {
        try {
            if (con.isOpen()) {
                con.rollback();
                con.close();
            }
        }
        catch (RepositoryException e) {
            this.logger.error(e.toString(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteArrayEntity copyEntity(HttpEntity entity, int length) throws IOException {
        InputStream in = entity.getContent();
        try {
            if (length < 0) {
                length = 1024;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(length);
            ChannelUtil.transfer(in, (OutputStream)baos);
            ByteArrayEntity bae = new ByteArrayEntity(baos.toByteArray());
            bae.setContentEncoding(entity.getContentEncoding());
            bae.setContentType(entity.getContentType());
            ByteArrayEntity byteArrayEntity = bae;
            return byteArrayEntity;
        }
        finally {
            in.close();
        }
    }

    private CloseableEntity endEntity(HttpEntity entity, final ObjectConnection con) {
        return new CloseableEntity(entity, new Closeable(){

            @Override
            public void close() {
                try {
                    TransactionHandler.this.executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            TransactionHandler.this.endTransaction(con);
                        }
                    });
                }
                catch (RejectedExecutionException ex) {
                    TransactionHandler.this.endTransaction(con);
                }
            }
        });
    }
}

