/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.chain;

import java.util.Date;
import java.util.Enumeration;
import java.util.concurrent.Future;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.concurrent.BasicFuture;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.protocol.HttpContext;
import org.openrdf.http.object.chain.AsyncExecChain;
import org.openrdf.http.object.helpers.ObjectContext;
import org.openrdf.http.object.helpers.Request;
import org.openrdf.http.object.helpers.ResponseBuilder;

public class UnmodifiedSinceHandler
implements AsyncExecChain {
    private final AsyncExecChain delegate;

    public UnmodifiedSinceHandler(AsyncExecChain delegate) {
        this.delegate = delegate;
    }

    @Override
    public Future<HttpResponse> execute(HttpHost target, HttpRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
        HttpResponse head = ObjectContext.adapt(context).getDerivedFromHeadResponse();
        Request req = new Request(request, context);
        if (head == null || this.unmodifiedSince(req, head.getFirstHeader("ETag"), head.getFirstHeader("Last-Modified"))) {
            return this.delegate.execute(target, request, context, callback);
        }
        BasicFuture future = new BasicFuture(callback);
        future.completed((Object)new ResponseBuilder(request, context).preconditionFailed("Resource has since been modified"));
        return future;
    }

    private boolean unmodifiedSince(Request request, Header eTag, Header lastModifiedHeader) {
        long lastModified = this.getDateHeader(lastModifiedHeader);
        Enumeration matchs = request.getHeaderEnumeration("If-Match");
        boolean mustMatch = matchs.hasMoreElements();
        try {
            long unmodified;
            if (lastModified > 0L && (unmodified = request.getDateHeader("If-Unmodified-Since")) > 0L && lastModified > unmodified) {
                return false;
            }
        }
        catch (IllegalArgumentException unmodified) {
            // empty catch block
        }
        if (eTag != null) {
            while (matchs.hasMoreElements()) {
                String match = (String)matchs.nextElement();
                if (!this.match(eTag.getValue(), match, request.isSafe())) continue;
                return true;
            }
        }
        return !mustMatch;
    }

    private boolean match(String tag, String match, boolean safe) {
        if (tag == null) {
            return false;
        }
        if ("*".equals(match)) {
            return true;
        }
        if (match.startsWith("W/") && !tag.startsWith("W/")) {
            match = match.substring(2);
        }
        if (match.equals(tag)) {
            return true;
        }
        int md = match.indexOf(45);
        int td = tag.indexOf(45);
        if (td >= 0 && md >= 0 && safe) {
            return false;
        }
        if (md < 0) {
            md = match.lastIndexOf(34);
        }
        if (td < 0) {
            td = tag.lastIndexOf(34);
        }
        int mq = match.indexOf(34);
        int tq = tag.indexOf(34);
        if (mq < 0 || tq < 0 || md < 0 || td < 0) {
            return false;
        }
        return match.substring(mq, md).equals(tag.substring(tq, td));
    }

    public long getDateHeader(Header header) {
        if (header == null) {
            return -1L;
        }
        Date date = DateUtils.parseDate((String)header.getValue());
        return date != null ? date.getTime() : -1L;
    }
}

