/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.cli;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Command {
    private final String name;
    private final Options options;
    private final String otherArgName;
    private final CommandLine parsed;
    private final ParseException exception;

    protected Command(String name, Options options, String otherArgName, CommandLine parsed) {
        this.name = name;
        this.options = options;
        this.otherArgName = otherArgName;
        this.parsed = parsed;
        this.exception = null;
    }

    public Command(String name, Options options, String otherArgName, CommandLine parsed, ParseException exception) {
        this.name = name;
        this.options = options;
        this.otherArgName = otherArgName;
        this.parsed = parsed;
        this.exception = exception;
    }

    public boolean isParseError() {
        if (this.exception != null) {
            return true;
        }
        if (this.otherArgName == null && this.parsed.getArgs().length > 0) {
            return true;
        }
        for (Object o : this.options.getRequiredOptions()) {
            String opt = (String)o;
            if (this.options.getOption(opt).hasOptionalArg() || this.get(opt) != null) continue;
            return true;
        }
        return false;
    }

    public void printParseError() {
        if (this.exception != null) {
            String msg = this.exception.getMessage();
            if (msg == null) {
                msg = this.exception.toString();
            }
            System.err.println(msg);
        } else if (this.parsed != null && this.otherArgName == null && this.parsed.getArgs().length > 0) {
            System.err.println("Unrecognized option: " + Arrays.toString(this.parsed.getArgs()));
        } else {
            for (Object o : this.options.getRequiredOptions()) {
                String opt = ((Option)o).getOpt();
                if (((Option)o).hasOptionalArg() || this.get(opt) != null) continue;
                System.err.println("Missing required option: " + opt);
            }
        }
        this.printHelp();
    }

    public void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("[options]", this.options);
    }

    public void printCommandName() {
        System.out.println(this.name);
    }

    public boolean has(String opt) {
        return this.parsed != null && this.parsed.hasOption(opt);
    }

    public String get(String opt) {
        String[] values = this.getAll(opt);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[values.length - 1];
    }

    public String[] getAll(String opt) {
        if (this.parsed == null) {
            return null;
        }
        if (opt.equals(this.otherArgName)) {
            return this.removeBlanks(this.parsed.getArgs());
        }
        return this.removeBlanks(this.parsed.getOptionValues(opt));
    }

    private String[] removeBlanks(String[] values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(values));
        list.remove(null);
        list.remove("");
        return list.toArray(new String[list.size()]);
    }
}

