/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.openrdf.http.object.cli.Command;

public class CommandSet {
    private final String name;
    private final Options options = new Options();
    private String otherArgName;
    private CommandLine line;

    public CommandSet(String version) {
        this.name = version;
    }

    public CommandOption require(String opt) {
        Option option = new Option(opt, opt);
        option.setRequired(true);
        return new CommandOption(option);
    }

    public CommandOption require(String opt, String longOpt) {
        Option option = new Option(opt, longOpt);
        if (!opt.equals(longOpt)) {
            option.setLongOpt(longOpt);
        }
        option.setRequired(true);
        return new CommandOption(option);
    }

    public CommandOption option(String opt) {
        Option option = new Option(opt, opt);
        return new CommandOption(option);
    }

    public CommandOption option(String opt, String longOpt) {
        Option option = new Option(opt, longOpt);
        if (!opt.equals(longOpt)) {
            option.setLongOpt(longOpt);
        }
        return new CommandOption(option);
    }

    public void other(String argName) {
        this.otherArgName = argName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Command parse(String[] args) {
        try {
            this.line = new GnuParser(){

                public CommandLine parse(Options options, String[] arguments) throws ParseException {
                    try {
                        return super.parse(options, arguments);
                    }
                    catch (ParseException e) {
                        CommandSet.this.line = this.cmd;
                        throw e;
                    }
                }
            }.parse(this.options, args);
            Command command = new Command(this.name, this.options, this.otherArgName, this.line);
            return command;
        }
        catch (ParseException e) {
            Command command = new Command(this.name, this.options, this.otherArgName, this.line, e);
            return command;
        }
        finally {
            this.line = null;
        }
    }

    public class CommandOption {
        private final Option option;

        protected CommandOption(Option option) {
            this.option = option;
        }

        public CommandOption arg(String argName) {
            this.option.setArgName(argName);
            this.option.setArgs(1);
            this.option.setOptionalArg(false);
            return this;
        }

        public CommandOption optional(String argName) {
            this.option.setArgName(argName);
            this.option.setArgs(1);
            this.option.setOptionalArg(true);
            return this;
        }

        public void desc(String description) {
            this.option.setDescription(description);
            CommandSet.this.options.addOption(this.option);
        }
    }
}

