/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.client;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.execchain.ClientExecChain;
import org.apache.http.impl.execchain.RequestAbortedException;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.openrdf.http.object.client.HttpAuthenticator;

public class AuthenticationClientExecChain
implements ClientExecChain {
    private final HttpAuthenticator authenticator = new HttpAuthenticator();
    private final ClientExecChain delegate;

    public AuthenticationClientExecChain(ClientExecChain delegate) {
        this.delegate = delegate;
    }

    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper original, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)original);
        RequestConfig config = context.getRequestConfig();
        CloseableHttpResponse response = null;
        while (true) {
            if (execAware != null && execAware.isAborted()) {
                throw new RequestAbortedException("Request aborted");
            }
            this.authenticator.generateAuthResponse(route, (HttpRequest)request, (HttpContext)context);
            response = this.delegate.execute(route, request, context, execAware);
            if (!config.isAuthenticationEnabled() || !this.authenticator.needAuthentication(route, (HttpRequest)request, (HttpResponse)response, (HttpContext)context)) break;
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        return response;
    }
}

