/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Future;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.client.cache.CachingHttpAsyncClient;
import org.apache.http.impl.client.cache.ManagedHttpCacheStorage;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;
import org.openrdf.http.object.client.CloseableEntity;
import org.openrdf.http.object.helpers.ResponseCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoClosingAsyncClient
extends CloseableHttpAsyncClient {
    final Logger logger = LoggerFactory.getLogger(AutoClosingAsyncClient.class);
    private final HttpAsyncClient backend;
    private final CachingHttpAsyncClient client;
    private final ManagedHttpCacheStorage storage;
    int numberOfClientCalls = 0;
    private boolean running;

    public AutoClosingAsyncClient(HttpAsyncClient backend, CachingHttpAsyncClient client, ManagedHttpCacheStorage storage) {
        this.backend = backend;
        this.client = client;
        this.storage = storage;
    }

    protected void finalize() throws Throwable {
        this.shutdown();
    }

    public void cleanResources() {
        this.storage.cleanResources();
    }

    public void shutdown() {
        this.running = false;
        this.logger.debug("Disposing of obsolete cache entries");
        this.storage.shutdown();
    }

    public void close() throws IOException {
        this.shutdown();
    }

    public void start() {
        this.running = true;
    }

    public boolean isRunning() {
        return this.running;
    }

    public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, HttpContext context, FutureCallback<T> callback) {
        throw new UnsupportedOperationException();
    }

    public Future<HttpResponse> execute(HttpHost target, HttpRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
        try {
            return this.client.execute(target, request, context, this.track(callback));
        }
        catch (Exception e) {
            this.logger.error(e.toString(), (Throwable)e);
            return this.backend.execute(target, request, context, this.track(callback));
        }
    }

    private FutureCallback<HttpResponse> track(FutureCallback<HttpResponse> callback) {
        return new ResponseCallback(callback){

            @Override
            public void completed(HttpResponse result) {
                try {
                    HttpEntity entity = result.getEntity();
                    if (entity != null) {
                        result.setEntity((HttpEntity)new CloseableEntity(entity, new Closeable(){

                            @Override
                            public void close() throws IOException {
                                if (++AutoClosingAsyncClient.this.numberOfClientCalls % 100 == 0) {
                                    AutoClosingAsyncClient.this.cleanResources();
                                }
                            }
                        }));
                    }
                    super.completed(result);
                }
                catch (RuntimeException ex) {
                    super.failed(ex);
                }
            }
        };
    }
}

