/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.client;

import java.io.Closeable;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.cache.ManagedHttpCacheStorage;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.openrdf.http.object.client.CloseableEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoClosingHttpClient
extends CloseableHttpClient {
    final Logger logger = LoggerFactory.getLogger(AutoClosingHttpClient.class);
    private final CloseableHttpClient client;
    private final ManagedHttpCacheStorage storage;
    private int numberOfClientCalls = 0;

    public AutoClosingHttpClient(CloseableHttpClient client, ManagedHttpCacheStorage storage) {
        this.client = client;
        this.storage = storage;
    }

    protected void finalize() throws Throwable {
        this.client.close();
        if (this.storage != null) {
            this.storage.shutdown();
        }
    }

    public void cleanResources() {
        if (this.storage != null) {
            this.storage.cleanResources();
        }
    }

    public void close() throws IOException {
        if (this.storage != null) {
            this.storage.cleanResources();
        }
    }

    protected CloseableHttpResponse doExecute(final HttpHost host, final HttpRequest request, HttpContext ctx) throws IOException, ClientProtocolException {
        CloseableHttpResponse resp;
        HttpEntity entity;
        if (++this.numberOfClientCalls % 100 == 0) {
            this.cleanResources();
        }
        if ((entity = (resp = this.client.execute(host, request, ctx)).getEntity()) != null) {
            resp.setEntity((HttpEntity)new CloseableEntity(entity, new Closeable(){

                @Override
                public void close() throws IOException {
                    String uri = request.getRequestLine().getUri();
                    AutoClosingHttpClient.this.logger.debug("Remote {}{} closed", (Object)host, (Object)uri);
                }
            }));
        }
        return resp;
    }

    public ClientConnectionManager getConnectionManager() {
        return this.client.getConnectionManager();
    }

    public HttpParams getParams() {
        return this.client.getParams();
    }
}

