/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.message.BasicHeader;
import org.openrdf.http.object.client.StreamingHttpEntity;

public class GUnzipEntity
extends StreamingHttpEntity {
    public GUnzipEntity(HttpEntity entity) {
        super(entity);
    }

    @Override
    protected InputStream getDelegateContent() throws IOException, IllegalStateException {
        InputStream in = super.getDelegateContent();
        GZIPInputStream unzip = null;
        try {
            unzip = new GZIPInputStream(in);
        }
        finally {
            if (unzip == null) {
                in.close();
            }
        }
        return unzip;
    }

    @Override
    public Header getContentEncoding() {
        return new BasicHeader("Content-Encoding", "identity");
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public boolean isChunked() {
        return true;
    }
}

