/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.client;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;
import org.openrdf.http.object.client.CloseableEntity;
import org.openrdf.http.object.client.GUnzipEntity;
import org.openrdf.http.object.client.GZipEntity;

public class GUnzipInterceptor
implements HttpResponseInterceptor {
    private final String hostname = this.getLocalHostName();
    private final String WARN_214 = "214 " + this.hostname + " \"Transformation applied\"";

    public void process(HttpResponse resp, HttpContext context) throws HttpException, IOException {
        HttpRequest req = (HttpRequest)context.getAttribute("http.request");
        HttpEntity entity = resp.getEntity();
        if (entity == null) {
            return;
        }
        Header cache = req.getFirstHeader("Cache-Control");
        if (cache != null && cache.getValue().contains("no-transform")) {
            return;
        }
        Header encoding = resp.getFirstHeader("Content-Encoding");
        if (encoding != null && "gzip".equals(encoding.getValue())) {
            resp.removeHeaders("Content-MD5");
            resp.removeHeaders("Content-Length");
            resp.setHeader("Content-Encoding", "identity");
            resp.addHeader("Warning", this.WARN_214);
            resp.setEntity(this.gunzip(entity));
        }
    }

    private HttpEntity gunzip(HttpEntity entity) {
        if (entity instanceof GZipEntity) {
            return ((GZipEntity)entity).getEntityDelegate();
        }
        if (entity instanceof CloseableEntity) {
            CloseableEntity centity = (CloseableEntity)entity;
            centity.setEntityDelegate(this.gunzip(centity.getEntityDelegate()));
            return centity;
        }
        return new GUnzipEntity(entity);
    }

    private String getLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName().toLowerCase();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }
}

