/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.message.BasicHeader;
import org.openrdf.http.object.client.StreamingHttpEntity;
import org.openrdf.http.object.io.ProducerStream;

public class GZipEntity
extends StreamingHttpEntity {
    public GZipEntity(HttpEntity entity) {
        super(entity);
    }

    @Override
    protected InputStream getDelegateContent() throws IOException {
        final InputStream in = GZipEntity.super.getDelegateContent();
        return new ProducerStream(new ProducerStream.OutputProducer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void produce(OutputStream pipe) throws IOException {
                GZIPOutputStream out = new GZIPOutputStream(pipe);
                try {
                    int read;
                    byte[] buf = new byte[512];
                    while ((read = in.read(buf)) >= 0) {
                        ((OutputStream)out).write(buf, 0, read);
                    }
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
        });
    }

    @Override
    public Header getContentEncoding() {
        return new BasicHeader("Content-Encoding", "gzip");
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public boolean isChunked() {
        return true;
    }
}

