/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.client;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthOption;
import org.apache.http.auth.AuthProtocolState;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.ContextAwareAuthScheme;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.client.TargetAuthenticationStrategy;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Asserts;

public class HttpAuthenticator {
    private final Log log = LogFactory.getLog(this.getClass());
    private final AuthenticationStrategy targetAuthStrategy = TargetAuthenticationStrategy.INSTANCE;
    private final AuthenticationStrategy proxyAuthStrategy = ProxyAuthenticationStrategy.INSTANCE;

    public void generateAuthResponse(HttpRoute route, HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (!request.containsHeader("Authorization")) {
            AuthState targetAuthState = this.getTargetAuthState(context);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Target auth state: " + targetAuthState.getState()));
            }
            this.generateAuthResponse(request, targetAuthState, context);
        }
        if (!request.containsHeader("Proxy-Authorization") && !route.isTunnelled()) {
            AuthState proxyAuthState = this.getProxyAuthState(context);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Proxy auth state: " + proxyAuthState.getState()));
            }
            this.generateAuthResponse(request, proxyAuthState, context);
        }
    }

    public boolean needAuthentication(HttpRoute route, HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        HttpHost proxy;
        AuthState targetAuthState = this.getTargetAuthState(context);
        AuthState proxyAuthState = this.getProxyAuthState(context);
        HttpHost target = (HttpHost)context.getAttribute("http.target_host");
        if (target == null) {
            target = route.getTargetHost();
        }
        if (this.needAuthentication(target, proxy = route.getProxyHost(), targetAuthState, proxyAuthState, response, context)) {
            request.removeHeaders("Authorization");
            request.removeHeaders("Proxy-Authorization");
            return true;
        }
        return false;
    }

    private boolean isAuthenticationRequested(HttpHost host, HttpResponse response, AuthenticationStrategy authStrategy, AuthState authState, HttpContext context) {
        if (authStrategy.isAuthenticationRequested(host, response, context)) {
            this.log.debug((Object)"Authentication required");
            if (authState.getState() == AuthProtocolState.SUCCESS) {
                authStrategy.authFailed(host, authState.getAuthScheme(), context);
            }
            return true;
        }
        switch (authState.getState()) {
            case CHALLENGED: 
            case HANDSHAKE: {
                this.log.debug((Object)"Authentication succeeded");
                authState.setState(AuthProtocolState.SUCCESS);
                authStrategy.authSucceeded(host, authState.getAuthScheme(), context);
                break;
            }
            case SUCCESS: {
                break;
            }
            default: {
                authState.setState(AuthProtocolState.UNCHALLENGED);
            }
        }
        return false;
    }

    private boolean handleAuthChallenge(HttpHost host, HttpResponse response, AuthenticationStrategy authStrategy, AuthState authState, HttpContext context) {
        try {
            Map challenges;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(host.toHostString() + " requested authentication"));
            }
            if ((challenges = authStrategy.getChallenges(host, response, context)).isEmpty()) {
                this.log.debug((Object)"Response contains no authentication challenges");
                return false;
            }
            AuthScheme authScheme = authState.getAuthScheme();
            switch (authState.getState()) {
                case FAILURE: {
                    return false;
                }
                case SUCCESS: {
                    authState.reset();
                    break;
                }
                case CHALLENGED: 
                case HANDSHAKE: {
                    if (authScheme == null) {
                        this.log.debug((Object)"Auth scheme is null");
                        authStrategy.authFailed(host, null, context);
                        authState.reset();
                        authState.setState(AuthProtocolState.FAILURE);
                        return false;
                    }
                }
                case UNCHALLENGED: {
                    if (authScheme == null) break;
                    String id = authScheme.getSchemeName();
                    Header challenge = (Header)challenges.get(id.toLowerCase(Locale.US));
                    if (challenge != null) {
                        this.log.debug((Object)"Authorization challenge processed");
                        authScheme.processChallenge(challenge);
                        if (authScheme.isComplete()) {
                            this.log.debug((Object)"Authentication failed");
                            authStrategy.authFailed(host, authState.getAuthScheme(), context);
                            authState.reset();
                            authState.setState(AuthProtocolState.FAILURE);
                            return false;
                        }
                        authState.setState(AuthProtocolState.HANDSHAKE);
                        return true;
                    }
                    authState.reset();
                }
            }
            Queue authOptions = authStrategy.select(challenges, host, response, context);
            if (authOptions != null && !authOptions.isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Selected authentication options: " + authOptions));
                }
                authState.setState(AuthProtocolState.CHALLENGED);
                authState.update(authOptions);
                return true;
            }
            return false;
        }
        catch (MalformedChallengeException ex) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("Malformed challenge: " + ex.getMessage()));
            }
            authState.reset();
            return false;
        }
    }

    private void generateAuthResponse(HttpRequest request, AuthState authState, HttpContext context) throws HttpException, IOException {
        block13: {
            AuthScheme authScheme = authState.getAuthScheme();
            Credentials creds = authState.getCredentials();
            switch (authState.getState()) {
                case FAILURE: {
                    return;
                }
                case SUCCESS: {
                    this.ensureAuthScheme(authScheme);
                    if (!authScheme.isConnectionBased()) break;
                    return;
                }
                case CHALLENGED: {
                    Queue authOptions = authState.getAuthOptions();
                    if (authOptions != null) {
                        while (!authOptions.isEmpty()) {
                            AuthOption authOption = (AuthOption)authOptions.remove();
                            authScheme = authOption.getAuthScheme();
                            creds = authOption.getCredentials();
                            authState.update(authScheme, creds);
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("Generating response to an authentication challenge using " + authScheme.getSchemeName() + " scheme"));
                            }
                            try {
                                Header header = this.doAuth(authScheme, creds, request, context);
                                request.addHeader(header);
                                break;
                            }
                            catch (AuthenticationException ex) {
                                if (!this.log.isWarnEnabled()) continue;
                                this.log.warn((Object)(authScheme + " authentication error: " + ex.getMessage()));
                            }
                        }
                        return;
                    }
                    this.ensureAuthScheme(authScheme);
                }
            }
            if (authScheme != null) {
                try {
                    Header header = this.doAuth(authScheme, creds, request, context);
                    request.addHeader(header);
                }
                catch (AuthenticationException ex) {
                    if (!this.log.isErrorEnabled()) break block13;
                    this.log.error((Object)(authScheme + " authentication error: " + ex.getMessage()));
                }
            }
        }
    }

    private void ensureAuthScheme(AuthScheme authScheme) {
        Asserts.notNull((Object)authScheme, (String)"Auth scheme");
    }

    private Header doAuth(AuthScheme authScheme, Credentials creds, HttpRequest request, HttpContext context) throws AuthenticationException {
        if (authScheme instanceof ContextAwareAuthScheme) {
            return ((ContextAwareAuthScheme)authScheme).authenticate(creds, request, context);
        }
        return authScheme.authenticate(creds, request);
    }

    private boolean needAuthentication(HttpHost target, HttpHost proxy, AuthState targetAuthState, AuthState proxyAuthState, HttpResponse response, HttpContext context) {
        if (this.targetAuthStrategy != null && this.isAuthenticationRequested(target, response, this.targetAuthStrategy, targetAuthState, context)) {
            return this.handleAuthChallenge(target, response, this.targetAuthStrategy, targetAuthState, context);
        }
        if (this.isAuthenticationRequested(proxy, response, this.proxyAuthStrategy, proxyAuthState, context)) {
            if (proxy == null) {
                proxy = target;
            }
            return this.handleAuthChallenge(proxy, response, this.proxyAuthStrategy, proxyAuthState, context);
        }
        return false;
    }

    private AuthState getTargetAuthState(HttpContext context) {
        AuthState targetAuthState = (AuthState)context.getAttribute("http.auth.target-scope");
        if (targetAuthState == null) {
            targetAuthState = new AuthState();
            context.setAttribute("http.auth.target-scope", (Object)targetAuthState);
        }
        return targetAuthState;
    }

    private AuthState getProxyAuthState(HttpContext context) {
        AuthState proxyAuthState = (AuthState)context.getAttribute("http.auth.proxy-scope");
        if (proxyAuthState == null) {
            proxyAuthState = new AuthState();
            context.setAttribute("http.auth.proxy-scope", (Object)proxyAuthState);
        }
        return proxyAuthState;
    }
}

