/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.client;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.cache.ResourceFactory;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.ConnectionRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.SystemDefaultCredentialsProvider;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClientBuilder;
import org.apache.http.impl.client.cache.FileResourceFactory;
import org.apache.http.impl.client.cache.ManagedHttpCacheStorage;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.execchain.ClientExecChain;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.openrdf.http.object.Version;
import org.openrdf.http.object.client.AutoClosingHttpClient;
import org.openrdf.http.object.client.GUnzipInterceptor;
import org.openrdf.http.object.client.GZipInterceptor;
import org.openrdf.http.object.client.HttpUriClient;
import org.openrdf.http.object.client.ProxyClientExecDecorator;

public class HttpClientFactory
implements Closeable {
    private static final String DEFAULT_NAME = Version.getInstance().getVersion();
    static HttpClientFactory instance = new HttpClientFactory();
    final long KEEPALIVE = this.getClientKeepAliveTimeout();
    final ProxyClientExecDecorator decorator = new ProxyClientExecDecorator();
    private ResourceFactory entryFactory;
    final PoolingHttpClientConnectionManager connManager;
    private final ConnectionReuseStrategy reuseStrategy;
    private final ConnectionKeepAliveStrategy keepAliveStrategy;

    public static synchronized HttpClientFactory getInstance() {
        return instance;
    }

    public static synchronized void setCacheDirectory(File dir) throws IOException {
        if (instance != null) {
            instance.close();
        }
        instance = new HttpClientFactory(dir);
    }

    private HttpClientFactory() {
        SSLConnectionSocketFactory sslSocketFactory = SSLConnectionSocketFactory.getSystemSocketFactory();
        this.connManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build());
        this.connManager.setDefaultSocketConfig(this.getDefaultSocketConfig());
        this.connManager.setDefaultConnectionConfig(this.getDefaultConnectionConfig());
        int max = Integer.parseInt(System.getProperty("http.maxConnections", "20"));
        this.connManager.setDefaultMaxPerRoute(max);
        this.connManager.setMaxTotal(2 * max);
        this.reuseStrategy = DefaultConnectionReuseStrategy.INSTANCE;
        this.keepAliveStrategy = new ConnectionKeepAliveStrategy(){
            private ConnectionKeepAliveStrategy delegate = DefaultConnectionKeepAliveStrategy.INSTANCE;

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                long ret = this.delegate.getKeepAliveDuration(response, context);
                if (ret > 0L) {
                    return ret;
                }
                return HttpClientFactory.this.KEEPALIVE;
            }
        };
    }

    private HttpClientFactory(File cacheDir) throws IOException {
        this();
        if (cacheDir != null) {
            cacheDir.mkdirs();
            this.entryFactory = new FileResourceFactory(cacheDir);
        }
    }

    @Override
    public synchronized void close() {
        this.connManager.shutdown();
    }

    public synchronized ClientExecChain getProxy(HttpHost destination) {
        return this.decorator.getProxy(destination);
    }

    public synchronized ClientExecChain putProxy(HttpHost destination, ClientExecChain proxy) {
        return this.decorator.putProxy(destination, proxy);
    }

    public synchronized ClientExecChain putProxyIfAbsent(HttpHost destination, ClientExecChain proxy) {
        return this.decorator.putProxyIfAbsent(destination, proxy);
    }

    public synchronized boolean removeProxy(HttpHost destination, ClientExecChain proxy) {
        return this.decorator.removeProxy(destination, proxy);
    }

    public synchronized boolean removeProxy(ClientExecChain proxy) {
        return this.decorator.removeProxy(proxy);
    }

    public HttpUriClient createHttpClient() {
        return this.createHttpClient(null, (CredentialsProvider)new SystemDefaultCredentialsProvider());
    }

    public synchronized HttpUriClient createHttpClient(CredentialsProvider credentials) {
        return this.createHttpClient(null, credentials);
    }

    public HttpUriClient createHttpClient(String source) {
        return this.createHttpClient(source, (CredentialsProvider)new SystemDefaultCredentialsProvider());
    }

    public synchronized HttpUriClient createHttpClient(String source, CredentialsProvider credentials) {
        CacheConfig cache = this.getDefaultCacheConfig();
        ManagedHttpCacheStorage storage = this.entryFactory == null ? null : new ManagedHttpCacheStorage(cache);
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        if (source != null && source.length() > 0) {
            headers.add(new BasicHeader("Origin", this.getOrigin(source)));
        }
        return new HttpUriClient(new AutoClosingHttpClient(this.createHttpClientBuilder(cache, storage).setConnectionManager(this.getConnectionManager()).setConnectionReuseStrategy(this.reuseStrategy).setKeepAliveStrategy(this.keepAliveStrategy).useSystemProperties().disableContentCompression().setDefaultRequestConfig(this.getDefaultRequestConfig()).addInterceptorFirst((HttpRequestInterceptor)new GZipInterceptor()).addInterceptorFirst((HttpResponseInterceptor)new GUnzipInterceptor()).setDefaultCredentialsProvider(credentials).setDefaultHeaders(headers).setUserAgent(DEFAULT_NAME).build(), storage));
    }

    private HttpClientBuilder createHttpClientBuilder(CacheConfig cache, ManagedHttpCacheStorage storage) {
        if (this.entryFactory == null) {
            return new HttpClientBuilder(){

                protected ClientExecChain decorateMainExec(ClientExecChain mainExec) {
                    return super.decorateMainExec(HttpClientFactory.this.decorator.decorateMainExec(mainExec));
                }
            };
        }
        return new CachingHttpClientBuilder(){

            protected ClientExecChain decorateMainExec(ClientExecChain mainExec) {
                return super.decorateMainExec(HttpClientFactory.this.decorator.decorateMainExec(mainExec));
            }
        }.setResourceFactory(this.entryFactory).setHttpCacheStorage((HttpCacheStorage)storage).setCacheConfig(cache);
    }

    private HttpClientConnectionManager getConnectionManager() {
        return new HttpClientConnectionManager(){

            public ConnectionRequest requestConnection(HttpRoute route, Object state) {
                return HttpClientFactory.this.connManager.requestConnection(route, state);
            }

            public void releaseConnection(HttpClientConnection conn, Object newState, long validDuration, TimeUnit timeUnit) {
                HttpClientFactory.this.connManager.releaseConnection(conn, newState, validDuration, timeUnit);
            }

            public void connect(HttpClientConnection conn, HttpRoute route, int connectTimeout, HttpContext context) throws IOException {
                HttpClientFactory.this.connManager.connect(conn, route, connectTimeout, context);
            }

            public void upgrade(HttpClientConnection conn, HttpRoute route, HttpContext context) throws IOException {
                HttpClientFactory.this.connManager.upgrade(conn, route, context);
            }

            public void routeComplete(HttpClientConnection conn, HttpRoute route, HttpContext context) throws IOException {
                HttpClientFactory.this.connManager.routeComplete(conn, route, context);
            }

            public void closeIdleConnections(long idletime, TimeUnit tunit) {
                HttpClientFactory.this.connManager.closeIdleConnections(idletime, tunit);
            }

            public void closeExpiredConnections() {
                HttpClientFactory.this.connManager.closeExpiredConnections();
            }

            public void shutdown() {
            }
        };
    }

    private String getOrigin(String source) {
        assert (source != null);
        int scheme = source.indexOf("://");
        if (scheme < 0 && (source.startsWith("file:") || source.startsWith("jar:file:"))) {
            return "file://";
        }
        if (scheme < 0) {
            throw new IllegalArgumentException("Not an absolute hierarchical URI: " + source);
        }
        int path = source.indexOf(47, scheme + 3);
        if (path >= 0) {
            return source.substring(0, path);
        }
        return source;
    }

    private RequestConfig getDefaultRequestConfig() {
        return RequestConfig.custom().setSocketTimeout(0).setConnectTimeout(10000).setStaleConnectionCheckEnabled(false).setExpectContinueEnabled(true).setMaxRedirects(20).setRedirectsEnabled(true).setCircularRedirectsAllowed(false).build();
    }

    private ConnectionConfig getDefaultConnectionConfig() {
        return ConnectionConfig.custom().setBufferSize(8192).build();
    }

    private SocketConfig getDefaultSocketConfig() {
        return SocketConfig.custom().setTcpNoDelay(false).setSoTimeout(60000).build();
    }

    private CacheConfig getDefaultCacheConfig() {
        return CacheConfig.custom().setSharedCache(false).setAllow303Caching(true).setWeakETagOnPutDeleteAllowed(true).setHeuristicCachingEnabled(true).setHeuristicDefaultLifetime(86400L).setMaxObjectSize(0x100000L).build();
    }

    private long getClientKeepAliveTimeout() {
        String pkg = HttpClientFactory.class.getPackage().getName();
        String keepAliveTimeout = this.getProperty(pkg + ".keepAliveTimeout");
        if (keepAliveTimeout != null && Pattern.matches("\\d+", keepAliveTimeout)) {
            return Math.abs(Long.parseLong(keepAliveTimeout));
        }
        return 4000L;
    }

    private String getProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (SecurityException e) {
            e.printStackTrace(System.err);
            return null;
        }
    }
}

