/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.openrdf.http.object.client.HttpUriEntity;
import org.openrdf.http.object.client.HttpUriResponse;
import org.openrdf.http.object.exceptions.ResponseException;
import org.openrdf.http.object.util.URLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUriClient
extends CloseableHttpClient
implements HttpClient {
    private final Logger logger = LoggerFactory.getLogger(HttpUriClient.class);
    private final HttpClient delegate;

    public HttpUriClient(HttpClient delegate) {
        this.delegate = delegate;
    }

    public HttpUriClient(CloseableHttpClient delegate) {
        this.delegate = delegate;
    }

    protected HttpClient getDelegate() throws IOException {
        return this.delegate;
    }

    public HttpUriEntity getEntity(String url, String accept) throws IOException, ResponseException {
        HttpGet req = new HttpGet(url);
        req.setHeader("Accept", accept);
        return this.getResponse((HttpUriRequest)req).getEntity();
    }

    public HttpUriResponse getResponse(HttpUriRequest request) throws IOException, ResponseException {
        HttpUriResponse response = this.getAnyResponse(request);
        int code = response.getStatusLine().getStatusCode();
        if (code < 200 || code >= 300) {
            throw ResponseException.create((HttpResponse)response, response.getSystemId());
        }
        return response;
    }

    public HttpUriResponse getAnyResponse(HttpUriRequest request) throws IOException, ResponseException {
        HttpClientContext ctx = HttpClientContext.create();
        ctx.setCookieStore((CookieStore)new BasicCookieStore());
        CloseableHttpResponse response = this.execute(request, (HttpContext)ctx);
        URI systemId = response instanceof HttpUriResponse ? ((HttpUriResponse)response).getURI() : this.getSystemId(ctx);
        if (response instanceof HttpUriResponse) {
            return (HttpUriResponse)response;
        }
        return new HttpUriResponse(systemId.toASCIIString(), (HttpResponse)response);
    }

    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        HttpResponse response;
        HttpClientContext ctx = context == null ? HttpClientContext.create() : HttpClientContext.adapt((HttpContext)context);
        if (ctx.getCookieStore() == null) {
            ctx.setCookieStore((CookieStore)new BasicCookieStore());
        }
        if ((response = this.getDelegate().execute(target, request, (HttpContext)ctx)) instanceof CloseableHttpResponse) {
            return (CloseableHttpResponse)response;
        }
        return new HttpUriResponse(this.getSystemId(ctx).toASCIIString(), response);
    }

    public void close() throws IOException {
        HttpClient delegate = this.getDelegate();
        if (delegate instanceof CloseableHttpClient) {
            ((CloseableHttpClient)delegate).close();
        }
    }

    public HttpParams getParams() {
        try {
            return this.getDelegate().getParams();
        }
        catch (IOException e) {
            this.logger.error(e.toString(), (Throwable)e);
            return null;
        }
    }

    public ClientConnectionManager getConnectionManager() {
        try {
            return this.getDelegate().getConnectionManager();
        }
        catch (IOException e) {
            this.logger.error(e.toString(), (Throwable)e);
            return null;
        }
    }

    private URI getSystemId(HttpClientContext ctx) {
        HttpUriRequest request = (HttpUriRequest)ctx.getRequest();
        try {
            URI original = request.getURI();
            HttpHost target = ctx.getTargetHost();
            List list = ctx.getRedirectLocations();
            URI absolute = URIUtils.resolve((URI)original, (HttpHost)target, (List)list);
            return new URI(URLUtil.canonicalize(absolute.toASCIIString()));
        }
        catch (URISyntaxException e) {
            return request.getURI();
        }
    }
}

