/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.client;

import java.io.IOException;
import java.net.URI;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.openrdf.http.object.client.HttpUriEntity;
import org.openrdf.http.object.util.URLUtil;

public class HttpUriResponse
implements CloseableHttpResponse {
    private final HttpResponse delegate;
    private final String systemId;

    public HttpUriResponse(String systemId, HttpResponse delegate) {
        assert (delegate != null);
        this.delegate = delegate;
        this.systemId = systemId;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public String getSystemId() {
        return this.systemId;
    }

    public URI getURI() {
        return URI.create(this.systemId);
    }

    public void close() throws IOException {
        if (this.delegate instanceof CloseableHttpResponse) {
            ((CloseableHttpResponse)this.delegate).close();
        }
    }

    public String getRedirectLocation() throws IOException {
        Header location;
        int code = this.getStatusLine().getStatusCode();
        if ((code == 301 || code == 302 || code == 307 || code == 308) && (location = this.getFirstHeader("Location")) != null) {
            EntityUtils.consume((HttpEntity)this.getEntity());
            String value = location.getValue();
            if (value.startsWith("/") || !value.contains(":")) {
                try {
                    value = URLUtil.resolve(value, this.systemId);
                }
                catch (IllegalArgumentException e) {
                    return value;
                }
            }
            return value;
        }
        return null;
    }

    public HttpUriEntity getEntity() {
        HttpEntity entity = this.delegate.getEntity();
        if (entity == null) {
            return null;
        }
        return new HttpUriEntity(this.systemId, entity);
    }

    public StatusLine getStatusLine() {
        return this.delegate.getStatusLine();
    }

    public void setStatusLine(StatusLine statusline) {
        this.delegate.setStatusLine(statusline);
    }

    public ProtocolVersion getProtocolVersion() {
        return this.delegate.getProtocolVersion();
    }

    public void setStatusLine(ProtocolVersion ver, int code) {
        this.delegate.setStatusLine(ver, code);
    }

    public boolean containsHeader(String name) {
        return this.delegate.containsHeader(name);
    }

    public void setStatusLine(ProtocolVersion ver, int code, String reason) {
        this.delegate.setStatusLine(ver, code, reason);
    }

    public Header[] getHeaders(String name) {
        return this.delegate.getHeaders(name);
    }

    public void setStatusCode(int code) throws IllegalStateException {
        this.delegate.setStatusCode(code);
    }

    public Header getFirstHeader(String name) {
        return this.delegate.getFirstHeader(name);
    }

    public Header getLastHeader(String name) {
        return this.delegate.getLastHeader(name);
    }

    public void setReasonPhrase(String reason) throws IllegalStateException {
        this.delegate.setReasonPhrase(reason);
    }

    public Header[] getAllHeaders() {
        return this.delegate.getAllHeaders();
    }

    public void addHeader(Header header) {
        this.delegate.addHeader(header);
    }

    public void addHeader(String name, String value) {
        this.delegate.addHeader(name, value);
    }

    public void setEntity(HttpEntity entity) {
        HttpUriEntity previously = this.getEntity();
        if (entity == null && previously != null) {
            EntityUtils.consumeQuietly((HttpEntity)previously);
        }
        this.delegate.setEntity(entity);
    }

    public void setHeader(Header header) {
        this.delegate.setHeader(header);
    }

    public void setHeader(String name, String value) {
        this.delegate.setHeader(name, value);
    }

    public Locale getLocale() {
        return this.delegate.getLocale();
    }

    public void setHeaders(Header[] headers) {
        this.delegate.setHeaders(headers);
    }

    public void setLocale(Locale loc) {
        this.delegate.setLocale(loc);
    }

    public void removeHeader(Header header) {
        this.delegate.removeHeader(header);
    }

    public void removeHeaders(String name) {
        this.delegate.removeHeaders(name);
    }

    public HeaderIterator headerIterator() {
        return this.delegate.headerIterator();
    }

    public HeaderIterator headerIterator(String name) {
        return this.delegate.headerIterator(name);
    }

    public HttpParams getParams() {
        return this.delegate.getParams();
    }

    public void setParams(HttpParams params) {
        this.delegate.setParams(params);
    }
}

