/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.client;

import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.UnsupportedSchemeException;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.impl.execchain.ClientExecChain;
import org.openrdf.http.object.client.AuthenticationClientExecChain;

public class ProxyClientExecDecorator {
    private final ConcurrentMap<HttpHost, ClientExecChain> proxies = new ConcurrentHashMap<HttpHost, ClientExecChain>();

    public ClientExecChain getProxy(HttpHost host) {
        return (ClientExecChain)this.proxies.get(host);
    }

    public ClientExecChain putProxy(HttpHost host, ClientExecChain proxy) {
        if (proxy == null) {
            return (ClientExecChain)this.proxies.remove(this.key(host));
        }
        return this.proxies.put(this.key(host), proxy);
    }

    public ClientExecChain putProxyIfAbsent(HttpHost host, ClientExecChain proxy) {
        assert (proxy != null);
        return this.proxies.putIfAbsent(this.key(host), proxy);
    }

    public boolean removeProxy(HttpHost host, ClientExecChain proxy) {
        return this.proxies.remove(this.key(host), proxy);
    }

    public boolean removeProxy(ClientExecChain proxy) {
        return this.proxies.values().removeAll(Collections.singleton(proxy));
    }

    public ClientExecChain decorateMainExec(final ClientExecChain mainExec) {
        return new ClientExecChain(){

            public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
                ClientExecChain proxy;
                HttpHost host = route.getTargetHost();
                if (host != null && (proxy = (ClientExecChain)ProxyClientExecDecorator.this.proxies.get(host)) != null) {
                    AuthenticationClientExecChain execChain = new AuthenticationClientExecChain(proxy);
                    return execChain.execute(route, request, context, execAware);
                }
                return mainExec.execute(route, request, context, execAware);
            }
        };
    }

    private HttpHost key(HttpHost host) {
        if (host != null && host.getPort() < 0) {
            try {
                int port = DefaultSchemePortResolver.INSTANCE.resolve(host);
                host = new HttpHost(host.getHostName(), port, host.getSchemeName());
            }
            catch (UnsupportedSchemeException e) {
                throw new AssertionError((Object)e);
            }
        }
        return host;
    }
}

