/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.client;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.HttpAsyncContentProducer;
import org.apache.http.util.EntityUtils;
import org.openrdf.http.object.io.ChannelUtil;

public class StreamingHttpEntity
implements HttpAsyncContentProducer,
HttpEntity {
    private HttpEntity entity;
    private InputStream in;
    private ReadableByteChannel cin;
    private ByteBuffer buf;
    private boolean chunked;
    private Header contentType;
    private long contentLength;
    private Header contentEncoding;

    public StreamingHttpEntity(HttpEntity entity) {
        this.setEntityDelegate(entity);
    }

    public final HttpEntity getEntityDelegate() {
        if (this.entity == null) {
            throw new IllegalStateException("Entity has already been consumed");
        }
        return this.entity;
    }

    public final void setEntityDelegate(HttpEntity entity) {
        assert (entity != null);
        this.entity = entity;
        this.chunked = entity.isChunked();
        this.contentType = entity.getContentType();
        this.contentLength = entity.getContentLength();
        this.contentEncoding = entity.getContentEncoding();
    }

    public String toString() {
        if (this.entity == null) {
            return "null";
        }
        return this.entity.toString();
    }

    public Header getContentEncoding() {
        return this.contentEncoding;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public Header getContentType() {
        return this.contentType;
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public final boolean isRepeatable() {
        return false;
    }

    public final boolean isStreaming() {
        return true;
    }

    public final void consumeContent() throws IOException {
        this.close();
    }

    public final synchronized InputStream getContent() throws IOException, IllegalStateException {
        if (this.in != null) {
            return this.in;
        }
        InputStream stream = this.getDelegateContent();
        if (ChannelUtil.isChannel(stream)) {
            final ReadableByteChannel delegate = ChannelUtil.newChannel(stream);
            this.in = ChannelUtil.newInputStream(new ReadableByteChannel(){

                @Override
                public boolean isOpen() {
                    return delegate.isOpen();
                }

                @Override
                public void close() throws IOException {
                    try {
                        delegate.close();
                    }
                    finally {
                        StreamingHttpEntity.this.closeEntity();
                    }
                }

                @Override
                public int read(ByteBuffer dst) throws IOException {
                    return delegate.read(dst);
                }
            });
            return this.in;
        }
        this.in = new FilterInputStream(stream){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    StreamingHttpEntity.this.closeEntity();
                }
            }
        };
        return this.in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws IOException {
        InputStream in = this.getContent();
        try {
            int l;
            byte[] buf = new byte[2048];
            while ((l = in.read(buf)) != -1) {
                out.write(buf, 0, l);
            }
        }
        finally {
            in.close();
        }
    }

    public final synchronized void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        if (this.cin == null) {
            this.cin = ChannelUtil.newChannel(this.getContent());
            this.buf = ByteBuffer.allocate(1024);
        }
        if (this.cin.read(this.buf) < 0 && this.buf.position() == 0) {
            this.close();
            if (!encoder.isCompleted()) {
                encoder.complete();
            }
        } else {
            this.buf.flip();
            encoder.write(this.buf);
            this.buf.compact();
        }
    }

    public final void close() throws IOException {
        try {
            this.closeEntity();
        }
        finally {
            if (this.cin != null) {
                this.cin.close();
                this.cin = null;
                this.buf = null;
            }
        }
    }

    protected InputStream getDelegateContent() throws IOException {
        return this.getEntityDelegate().getContent();
    }

    protected void finish() throws IOException {
    }

    final void closeEntity() throws IOException {
        try {
            if (this.entity instanceof HttpAsyncContentProducer) {
                ((HttpAsyncContentProducer)this.entity).close();
            } else if (this.entity != null) {
                EntityUtils.consume((HttpEntity)this.entity);
            }
        }
        finally {
            this.entity = null;
            this.finish();
        }
    }
}

