/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.openrdf.http.object.concurrent.ManagedExecutors;
import org.openrdf.http.object.concurrent.ManagedThreadPool;

public class AntiDeadlockThreadPool
extends ManagedThreadPool {
    private static ScheduledExecutorService scheduler = ManagedExecutors.getInstance().getTimeoutThreadPool();
    private final long delay;
    private final TimeUnit delayUnit;
    int corePoolSize;
    int maximumPoolSize;
    BlockingQueue<Runnable> queue;
    ScheduledFuture<?> schedule;

    public AntiDeadlockThreadPool(int corePoolSize, int maximumPoolSize, BlockingQueue<Runnable> queue, String name) {
        this(corePoolSize, maximumPoolSize, queue, name, 5L, TimeUnit.SECONDS);
    }

    public AntiDeadlockThreadPool(int corePoolSize, int maximumPoolSize, BlockingQueue<Runnable> queue, String name, long delay, TimeUnit delayUnit) {
        super(corePoolSize, maximumPoolSize, 60L, TimeUnit.MINUTES, queue, name, true);
        this.queue = queue;
        this.corePoolSize = corePoolSize;
        this.maximumPoolSize = maximumPoolSize;
        this.setAllowCoreThreadTimeOut(true);
        this.delay = delay;
        this.delayUnit = delayUnit;
    }

    @Override
    public synchronized void execute(Runnable command) {
        try {
            super.execute(command);
        }
        finally {
            this.checkQueue();
        }
    }

    @Override
    public synchronized Future<?> submit(Runnable task) {
        try {
            Future<?> future = super.submit(task);
            return future;
        }
        finally {
            this.checkQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized <T> Future<T> submit(Runnable task, T result) {
        try {
            Future<T> future = super.submit(task, result);
            return future;
        }
        finally {
            this.checkQueue();
        }
    }

    @Override
    public synchronized <T> Future<T> submit(Callable<T> task) {
        try {
            Future<T> future = super.submit(task);
            return future;
        }
        finally {
            this.checkQueue();
        }
    }

    private synchronized void checkQueue() {
        if (this.corePoolSize >= this.maximumPoolSize) {
            return;
        }
        final Runnable top = (Runnable)this.queue.peek();
        if (this.schedule == null && top != null) {
            this.schedule = scheduler.scheduleWithFixedDelay(new Runnable(){
                private Runnable previous;
                {
                    this.previous = top;
                }

                public String toString() {
                    return "check for starving tasks";
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AntiDeadlockThreadPool antiDeadlockThreadPool = AntiDeadlockThreadPool.this;
                    synchronized (antiDeadlockThreadPool) {
                        Runnable peek = (Runnable)AntiDeadlockThreadPool.this.queue.peek();
                        if (peek == null || AntiDeadlockThreadPool.this.corePoolSize >= AntiDeadlockThreadPool.this.maximumPoolSize) {
                            if (AntiDeadlockThreadPool.this.schedule != null) {
                                AntiDeadlockThreadPool.this.schedule.cancel(false);
                                AntiDeadlockThreadPool.this.schedule = null;
                            }
                        } else if (this.previous == peek) {
                            AntiDeadlockThreadPool.this.setCorePoolSize(++AntiDeadlockThreadPool.this.corePoolSize);
                        } else {
                            this.previous = peek;
                        }
                    }
                }
            }, this.delay, this.delay, this.delayUnit);
        }
    }
}

