/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.concurrent;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.openrdf.http.object.concurrent.AntiDeadlockThreadPool;
import org.openrdf.http.object.concurrent.ManagedScheduledThreadPool;
import org.openrdf.http.object.concurrent.ManagedThreadPool;
import org.openrdf.http.object.concurrent.ManagedThreadPoolListener;

public class ManagedExecutors {
    private static final ManagedExecutors instance = new ManagedExecutors();
    private final Map<String, WeakReference<? extends ManagedThreadPool>> pools = new LinkedHashMap<String, WeakReference<? extends ManagedThreadPool>>();
    private final List<ManagedThreadPoolListener> listeners = new ArrayList<ManagedThreadPoolListener>();
    private ExecutorService producerThreadPool = this.newCachedPool("Producer");
    private ExecutorService parserThreadPool = this.newCachedPool("Parser");
    private ScheduledExecutorService timeoutThreadPool = this.newSingleScheduler("Timeout");

    public static ManagedExecutors getInstance() {
        return instance;
    }

    public ExecutorService getProducerThreadPool() {
        return this.producerThreadPool;
    }

    public ExecutorService getParserThreadPool() {
        return this.parserThreadPool;
    }

    public ScheduledExecutorService getTimeoutThreadPool() {
        return this.timeoutThreadPool;
    }

    public ExecutorService newCachedPool(String name) {
        return this.register(new ManagedThreadPool(name, true));
    }

    public ExecutorService newFixedThreadPool(int nThreads, String name) {
        return this.newFixedThreadPool(nThreads, new LinkedBlockingDeque<Runnable>(), name);
    }

    public ExecutorService newFixedThreadPool(int nThreads, BlockingQueue<Runnable> queue, String name) {
        return this.register(new ManagedThreadPool(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, queue, name, true));
    }

    public ScheduledExecutorService newSingleScheduler(String name) {
        return this.register(new ManagedScheduledThreadPool(name, true));
    }

    public ExecutorService newAntiDeadlockThreadPool(BlockingQueue<Runnable> queue, String name) {
        return this.newAntiDeadlockThreadPool(Runtime.getRuntime().availableProcessors() * 2 + 1, Runtime.getRuntime().availableProcessors() * 100, queue, name);
    }

    public ExecutorService newAntiDeadlockThreadPool(int corePoolSize, int maximumPoolSize, BlockingQueue<Runnable> queue, String name) {
        return this.register(new AntiDeadlockThreadPool(corePoolSize, maximumPoolSize, queue, name));
    }

    public synchronized void addListener(ManagedThreadPoolListener listener) {
        this.cleanup(null);
        for (String name : this.pools.keySet()) {
            WeakReference<? extends ManagedThreadPool> ref = this.pools.get(name);
            ManagedThreadPool pool = (ManagedThreadPool)ref.get();
            if (pool == null || pool.isTerminated()) continue;
            listener.threadPoolStarted(name, pool);
        }
        this.listeners.add(listener);
    }

    public synchronized void removeListener(ManagedThreadPoolListener listener) {
        this.listeners.remove(listener);
        this.cleanup(null);
    }

    public synchronized void cleanup() {
        this.cleanup(null);
        Iterator<String> iter = this.pools.keySet().iterator();
        while (iter.hasNext()) {
            String name = iter.next();
            WeakReference<? extends ManagedThreadPool> ref = this.pools.get(name);
            ManagedThreadPool get = (ManagedThreadPool)ref.get();
            if (get != null && !get.isTerminated() && !get.isTerminating()) continue;
            if (get != null && !get.isTerminated() && get.isTerminating()) {
                try {
                    get.awaitTermination(1L, TimeUnit.HOURS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            for (ManagedThreadPoolListener listener : this.listeners) {
                listener.threadPoolTerminated(name);
            }
            iter.remove();
        }
    }

    private synchronized <T extends ManagedThreadPool> T register(T pool) {
        String key = pool.toString();
        assert (key != null);
        this.cleanup(key);
        this.pools.put(key, new WeakReference<T>(pool));
        for (ManagedThreadPoolListener listener : this.listeners) {
            listener.threadPoolStarted(key, pool);
        }
        return pool;
    }

    private synchronized void cleanup(String nameToTerminate) {
        Iterator<String> iter = this.pools.keySet().iterator();
        while (iter.hasNext()) {
            String name = iter.next();
            WeakReference<? extends ManagedThreadPool> ref = this.pools.get(name);
            ManagedThreadPool get = (ManagedThreadPool)ref.get();
            if (get != null && !get.isTerminated() && !name.equals(nameToTerminate)) continue;
            if (name.equals(nameToTerminate) && get != null && !get.isTerminated()) {
                get.shutdownNow();
                try {
                    get.awaitTermination(1L, TimeUnit.HOURS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            for (ManagedThreadPoolListener listener : this.listeners) {
                listener.threadPoolTerminated(name);
            }
            iter.remove();
        }
    }

    private ManagedExecutors() {
    }
}

