/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.openrdf.http.object.concurrent.ManagedThreadPool;
import org.openrdf.http.object.concurrent.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedScheduledThreadPool
extends ManagedThreadPool
implements ScheduledExecutorService {
    private final Logger logger = LoggerFactory.getLogger(ManagedScheduledThreadPool.class);

    protected ManagedScheduledThreadPool(String name, boolean daemon) {
        this(1, name, daemon, new ThreadPoolExecutor.AbortPolicy());
    }

    protected ManagedScheduledThreadPool(int corePoolSize, String name, boolean daemon) {
        this(corePoolSize, name, daemon, new ThreadPoolExecutor.AbortPolicy());
    }

    protected ManagedScheduledThreadPool(int corePoolSize, String name, boolean daemon, RejectedExecutionHandler handler) {
        super(new ScheduledThreadPoolExecutor(corePoolSize, handler), new NamedThreadFactory(name, daemon));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void interruptWorkers() throws InterruptedException {
        int corePoolSize = this.getCorePoolSize();
        ThreadFactory factory = this.getDelegate().getThreadFactory();
        RejectedExecutionHandler handler = this.getDelegate().getRejectedExecutionHandler();
        try {
            this.logger.info("Terminating {} {} threads", (Object)this.getActiveCount(), (Object)this.toString());
            this.getDelegate().shutdown();
            if (!this.getDelegate().awaitTermination(1L, TimeUnit.MINUTES)) {
                this.logger.info("Could not terminate {} {} threads", (Object)this.getActiveCount(), (Object)this.toString());
            }
        }
        finally {
            this.setDelegate(new ScheduledThreadPoolExecutor(corePoolSize, factory, handler));
        }
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.getDelegate().schedule(callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.getDelegate().schedule(command, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.getDelegate().scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.getDelegate().scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    @Override
    protected synchronized ScheduledThreadPoolExecutor getDelegate() {
        return (ScheduledThreadPoolExecutor)super.getDelegate();
    }
}

