/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.concurrent;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openrdf.http.object.concurrent.NamedThreadFactory;
import org.openrdf.http.object.concurrent.ThreadPoolMXBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedThreadPool
implements ExecutorService,
ThreadPoolMXBean {
    private final Logger logger = LoggerFactory.getLogger(ManagedThreadPool.class);
    private ThreadPoolExecutor delegate;
    private final NamedThreadFactory threads;

    protected ManagedThreadPool(String name, boolean daemon) {
        this(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), name, daemon, new ThreadPoolExecutor.AbortPolicy());
    }

    protected ManagedThreadPool(int nThreads, String name, boolean daemon) {
        this(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), name, daemon, new ThreadPoolExecutor.AbortPolicy());
    }

    protected ManagedThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, String name, boolean daemon) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, name, daemon, new ThreadPoolExecutor.AbortPolicy());
    }

    protected ManagedThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, String name, boolean daemon, RejectedExecutionHandler handler) {
        this(new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler), new NamedThreadFactory(name, daemon));
    }

    protected ManagedThreadPool(ThreadPoolExecutor delegate, NamedThreadFactory factory) {
        this.threads = factory;
        delegate.setThreadFactory(factory);
        this.setDelegate(delegate);
    }

    @Override
    public String getName() {
        return this.threads.toString();
    }

    public String toString() {
        return this.threads.toString();
    }

    @Override
    public void setCorePoolSize(int corePoolSize) {
        if (this.getCorePoolSize() < corePoolSize) {
            this.logger.info("Increasing {} thread pool size to {}", (Object)this.toString(), (Object)corePoolSize);
        }
        this.getDelegate().setCorePoolSize(corePoolSize);
    }

    @Override
    public void shutdown() {
        this.getDelegate().shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        List<Runnable> tasks = this.getDelegate().shutdownNow();
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void interruptWorkers() throws InterruptedException {
        int corePoolSize = this.getCorePoolSize();
        int maximumPoolSize = this.getMaximumPoolSize();
        long keepAliveTime = this.getKeepAliveTime();
        TimeUnit unit = TimeUnit.SECONDS;
        BlockingQueue<Runnable> workQueue = this.getDelegate().getQueue();
        ThreadFactory factory = this.getDelegate().getThreadFactory();
        RejectedExecutionHandler handler = this.getDelegate().getRejectedExecutionHandler();
        try {
            this.logger.info("Terminating {} {} threads", (Object)this.getActiveCount(), (Object)this.toString());
            this.getDelegate().shutdown();
            if (!this.getDelegate().awaitTermination(1L, TimeUnit.MINUTES)) {
                this.logger.info("Could not terminate {} {} threads", (Object)this.getActiveCount(), (Object)this.toString());
            }
        }
        finally {
            this.setDelegate(new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, factory, handler));
        }
    }

    @Override
    public void clearQueue() {
        this.getQueue().clear();
    }

    @Override
    public long getKeepAliveTime() {
        return this.getDelegate().getKeepAliveTime(TimeUnit.SECONDS);
    }

    @Override
    public void setKeepAliveTime(long seconds) {
        this.getDelegate().setKeepAliveTime(seconds, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void threadDumpToFile(String outputFile) throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter(outputFile, true));
        try {
            writer.print("Name:\t");
            writer.println(this.getName());
            writer.print("Active:\t");
            writer.println(this.getActiveCount());
            writer.print("Task count:\t");
            writer.println(this.getTaskCount());
            writer.print("Completed task count:\t");
            writer.println(this.getCompletedTaskCount());
            writer.print("Pool size:\t");
            writer.println(this.getPoolSize());
            writer.print("Core pool size:\t");
            writer.println(this.getCorePoolSize());
            writer.print("Largest pool size:\t");
            writer.println(this.getLargestPoolSize());
            writer.print("Maximum pool size:\t");
            writer.println(this.getMaximumPoolSize());
            writer.print("Keep alive Time:\t");
            writer.println(this.getKeepAliveTime());
            writer.print("Queue size:\t");
            writer.println(this.getQueueSize());
            writer.print("Queue remaining capacity:\t");
            writer.println(this.getQueueRemainingCapacity());
            writer.print("Allow core thread time out:\t");
            writer.println(this.isAllowsCoreThreadTimeOut());
            writer.print("Continue existing periodic tasks after shutdown:\t");
            writer.println(this.isContinueExistingPeriodicTasksAfterShutdownPolicy());
            writer.print("Execute existing delayed tasks after shutdown:\t");
            writer.println(this.isExecuteExistingDelayedTasksAfterShutdownPolicy());
            writer.print("Shutdown:\t");
            writer.println(this.isShutdown());
            writer.print("Terminating:\t");
            writer.println(this.isTerminating());
            writer.print("Terminated:\t");
            writer.println(this.isTerminated());
            writer.println();
            for (String trace : this.getActiveStackDump()) {
                writer.println(trace);
                writer.println();
            }
            for (String pending : this.getQueueDescription()) {
                writer.println(pending);
            }
            writer.println();
            writer.println();
        }
        finally {
            writer.close();
        }
        this.logger.info("Thread pool dump: {}", (Object)outputFile);
    }

    @Override
    public String[] getActiveStackDump() {
        ThreadMXBean mxBean = ManagementFactory.getThreadMXBean();
        ArrayList<String> result = new ArrayList<String>();
        for (ThreadInfo info : this.getLiveThreadInfo(Integer.MAX_VALUE)) {
            if (this.isWaitingForNewTask(info)) continue;
            StringWriter writer = new StringWriter();
            PrintWriter s = new PrintWriter(writer);
            this.printThreadInfo(info, mxBean, s);
            this.printStackTrace(info.getStackTrace(), info, s);
            this.printLockInfo(info.getLockedSynchronizers(), s);
            s.flush();
            result.add(writer.toString());
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public ThreadInfo[] getLiveThreadInfo(int maxDepth) {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        Thread[] liveThreads = this.threads.getLiveThreads();
        ThreadInfo[] result = new ThreadInfo[liveThreads.length];
        for (int i = 0; i < liveThreads.length; ++i) {
            result[i] = bean.getThreadInfo(liveThreads[i].getId(), maxDepth);
        }
        return result;
    }

    @Override
    public String[] getQueueDescription() {
        Object[] tasks = this.getQueue().toArray();
        String[] result = new String[tasks.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = tasks[i].toString();
        }
        return result;
    }

    @Override
    public void runAllInQueue() {
        Runnable task;
        while ((task = (Runnable)this.getQueue().poll()) != null) {
            task.run();
        }
    }

    @Override
    public void runNextInQueue() {
        Runnable task = (Runnable)this.getQueue().poll();
        if (task != null) {
            task.run();
        }
    }

    @Override
    public int getQueueRemainingCapacity() {
        return this.getQueue().remainingCapacity();
    }

    @Override
    public int getQueueSize() {
        return this.getQueue().size();
    }

    @Override
    public boolean isAllowsCoreThreadTimeOut() {
        return this.getDelegate().allowsCoreThreadTimeOut();
    }

    @Override
    public boolean isContinueExistingPeriodicTasksAfterShutdownPolicy() {
        return false;
    }

    @Override
    public boolean isExecuteExistingDelayedTasksAfterShutdownPolicy() {
        return false;
    }

    @Override
    public void setAllowCoreThreadTimeOut(boolean allow) {
        this.getDelegate().allowCoreThreadTimeOut(allow);
    }

    @Override
    public void setContinueExistingPeriodicTasksAfterShutdownPolicy(boolean policy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setExecuteExistingDelayedTasksAfterShutdownPolicy(boolean policy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void startAllCoreThreads() {
        this.getDelegate().prestartAllCoreThreads();
    }

    @Override
    public void startCoreThread() {
        this.getDelegate().prestartCoreThread();
    }

    @Override
    public int getActiveCount() {
        return this.getDelegate().getActiveCount();
    }

    @Override
    public long getCompletedTaskCount() {
        return this.getDelegate().getCompletedTaskCount();
    }

    @Override
    public int getCorePoolSize() {
        return this.getDelegate().getCorePoolSize();
    }

    @Override
    public int getPoolSize() {
        return this.getDelegate().getPoolSize();
    }

    @Override
    public long getTaskCount() {
        return this.getDelegate().getTaskCount();
    }

    @Override
    public boolean isTerminating() {
        return this.getDelegate().isTerminating();
    }

    @Override
    public int getLargestPoolSize() {
        return this.getDelegate().getLargestPoolSize();
    }

    @Override
    public int getMaximumPoolSize() {
        return this.getDelegate().getMaximumPoolSize();
    }

    @Override
    public void purge() {
        this.getDelegate().purge();
    }

    @Override
    public void setMaximumPoolSize(int maximumPoolSize) {
        this.getDelegate().setMaximumPoolSize(maximumPoolSize);
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.getDelegate().awaitTermination(timeout, unit);
    }

    @Override
    public boolean isShutdown() {
        return this.getDelegate().isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.getDelegate().isTerminated();
    }

    @Override
    public void execute(Runnable command) {
        this.getDelegate().execute(command);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.getDelegate().invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.getDelegate().invokeAll(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.getDelegate().invokeAny(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.getDelegate().invokeAny(tasks);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.getDelegate().submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.getDelegate().submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.getDelegate().submit(task);
    }

    protected synchronized ThreadPoolExecutor getDelegate() {
        return this.delegate;
    }

    protected synchronized void setDelegate(ThreadPoolExecutor delegate) {
        this.delegate = delegate;
    }

    private BlockingQueue<Runnable> getQueue() {
        return this.getDelegate().getQueue();
    }

    private boolean isWaitingForNewTask(ThreadInfo info) {
        if (info.getThreadState() == Thread.State.RUNNABLE) {
            return false;
        }
        StackTraceElement[] stack = info.getStackTrace();
        if (stack.length < 4) {
            return false;
        }
        for (int i = stack.length - 1; i >= 0; --i) {
            StackTraceElement trace = stack[i];
            String cname = trace.getClassName();
            if (cname.startsWith(ThreadPoolExecutor.class.getName())) {
                if (!"getTask".equals(trace.getMethodName())) continue;
                return true;
            }
            if (Thread.class.getName().equals(cname)) continue;
            return false;
        }
        return false;
    }

    private void printThreadInfo(ThreadInfo threadInfo, ThreadMXBean mxBean, PrintWriter writer) {
        writer.println("    native=" + threadInfo.isInNative() + ", suspended=" + threadInfo.isSuspended() + ", block=" + threadInfo.getBlockedCount() + ", wait=" + threadInfo.getWaitedCount());
        writer.println("    lock=" + threadInfo.getLockName() + " owned by " + threadInfo.getLockOwnerName() + " (" + threadInfo.getLockOwnerId() + "), cpu=" + mxBean.getThreadCpuTime(threadInfo.getThreadId()) / 1000000L + ", user=" + mxBean.getThreadUserTime(threadInfo.getThreadId()) / 1000000L);
    }

    private void printStackTrace(StackTraceElement[] stacktrace, ThreadInfo threadInfo, PrintWriter writer) {
        MonitorInfo[] monitors = threadInfo.getLockedMonitors();
        for (int i = 0; i < stacktrace.length; ++i) {
            StackTraceElement ste = stacktrace[i];
            writer.println("\tat " + ste.toString());
            for (MonitorInfo mi : monitors) {
                if (mi.getLockedStackDepth() != i) continue;
                writer.println("\t  - locked " + mi);
            }
        }
        writer.println();
    }

    private void printLockInfo(LockInfo[] locks, PrintWriter s) {
        s.println("\tLocked synchronizers: count = " + locks.length);
        for (LockInfo li : locks) {
            s.println("\t  - " + li);
        }
    }
}

