/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.concurrent;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadFactory;

public class NamedThreadFactory
implements ThreadFactory {
    private static volatile int COUNT = 0;
    private String name;
    private boolean daemon;
    private final List<Thread> threads = new ArrayList<Thread>();

    public NamedThreadFactory(String name, boolean daemon) {
        this.name = name;
        this.daemon = daemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread[] getLiveThreads() {
        List<Thread> list = this.threads;
        synchronized (list) {
            this.removeTerminatedThreads();
            return this.threads.toArray(new Thread[this.threads.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(r, this.name + "-" + ++COUNT);
        if (thread.isDaemon() != this.daemon) {
            thread.setDaemon(this.daemon);
        }
        List<Thread> list = this.threads;
        synchronized (list) {
            this.removeTerminatedThreads();
            this.threads.add(thread);
        }
        return thread;
    }

    public String toString() {
        return this.name;
    }

    private void removeTerminatedThreads() {
        Iterator<Thread> iter = this.threads.iterator();
        while (iter.hasNext()) {
            Thread thread = iter.next();
            if (thread.isAlive()) continue;
            iter.remove();
        }
    }
}

