/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.exceptions;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.openrdf.http.object.exceptions.BadGateway;
import org.openrdf.http.object.exceptions.BadRequest;
import org.openrdf.http.object.exceptions.Conflict;
import org.openrdf.http.object.exceptions.Forbidden;
import org.openrdf.http.object.exceptions.GatewayTimeout;
import org.openrdf.http.object.exceptions.Gone;
import org.openrdf.http.object.exceptions.InternalServerError;
import org.openrdf.http.object.exceptions.MethodNotAllowed;
import org.openrdf.http.object.exceptions.NotAcceptable;
import org.openrdf.http.object.exceptions.NotFound;
import org.openrdf.http.object.exceptions.NotImplemented;
import org.openrdf.http.object.exceptions.PreconditionRequired;
import org.openrdf.http.object.exceptions.ServiceUnavailable;
import org.openrdf.http.object.exceptions.TooManyRequests;
import org.openrdf.http.object.exceptions.UnsupportedMediaType;

public abstract class ResponseException
extends RuntimeException {
    private final List<Header> headers = new ArrayList<Header>();
    private static final long serialVersionUID = -4156041448577237448L;
    private String msg;
    private String full;

    public static ResponseException create(HttpResponse resp) throws IOException {
        return ResponseException.create(resp, null);
    }

    public static ResponseException create(HttpResponse resp, String from) throws IOException {
        StatusLine line = resp.getStatusLine();
        int code = line.getStatusCode();
        String[] titleBody = ResponseException.readMessage(resp, line.getReasonPhrase());
        String msg = titleBody[0];
        String stack = titleBody[1];
        if (from != null && from.length() > 0) {
            stack = stack.contains("\n") ? stack.replaceFirst("\n", " from " + from + "\n") : stack + " from " + from;
        }
        return ResponseException.create(code, msg, stack);
    }

    private static ResponseException create(int status, String msg, String stack) {
        switch (status) {
            case 400: {
                return new BadRequest(msg, stack);
            }
            case 403: {
                return new Forbidden(msg, stack);
            }
            case 404: {
                return new NotFound(msg, stack);
            }
            case 405: {
                return new MethodNotAllowed(msg, stack);
            }
            case 406: {
                return new NotAcceptable(msg, stack);
            }
            case 409: {
                return new Conflict(msg, stack);
            }
            case 410: {
                return new Gone(msg, stack);
            }
            case 415: {
                return new UnsupportedMediaType(msg, stack);
            }
            case 428: {
                return new PreconditionRequired(msg, stack);
            }
            case 429: {
                return new TooManyRequests(msg, stack);
            }
            case 500: {
                return new InternalServerError(msg, stack);
            }
            case 501: {
                return new NotImplemented(msg, stack);
            }
            case 503: {
                return new ServiceUnavailable(msg, stack);
            }
            case 504: {
                return new GatewayTimeout(msg, stack);
            }
        }
        return new BadGateway(msg, stack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] readMessage(HttpResponse resp, String defaultTitle) throws IOException {
        HttpEntity entity = resp.getEntity();
        if (entity == null) {
            return new String[]{defaultTitle, defaultTitle};
        }
        try {
            StringWriter string = new StringWriter();
            InputStream in = entity.getContent();
            Header hd = resp.getFirstHeader("Content-Encoding");
            if (hd != null && "gzip".equals(hd.getValue())) {
                in = new GZIPInputStream(in);
            }
            InputStreamReader reader = new InputStreamReader(in, "UTF-8");
            try {
                int read;
                char[] cbuf = new char[1024];
                while ((read = reader.read(cbuf)) >= 0) {
                    string.write(cbuf, 0, read);
                }
            }
            finally {
                reader.close();
            }
            String title = defaultTitle;
            String body = string.toString();
            if (body.startsWith("<")) {
                if (body.contains("<title") && body.contains("</title>")) {
                    title = body.substring(body.indexOf("<title"), body.indexOf("</title>"));
                    title = title.replaceAll("<title[^>]*>\\s*", "");
                    title = ResponseException.decodeHtmlText(title).trim();
                } else if (body.contains("<TITLE") && body.contains("</TITLE>")) {
                    title = body.substring(body.indexOf("<TITLE"), body.indexOf("</TITLE>"));
                    title = title.replaceAll("<TITLE[^>]*>\\s*", "");
                    title = ResponseException.decodeHtmlText(title).trim();
                } else {
                    title = defaultTitle;
                }
                if (body.contains("<pre") && body.contains("</pre>")) {
                    body = body.substring(body.indexOf("<pre"), body.indexOf("</pre>"));
                    body = body.replaceAll("<pre[^>]*>", "");
                    body = ResponseException.decodeHtmlText(body);
                } else if (body.contains("<PRE") && body.contains("</PRE>")) {
                    body = body.substring(body.indexOf("<PRE"), body.indexOf("</PRE>"));
                    body = body.replaceAll("<PRE[^>]*>", "");
                    body = ResponseException.decodeHtmlText(body);
                } else {
                    body = title;
                }
            }
            String[] stringArray = new String[]{title, body.trim()};
            return stringArray;
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        catch (IOException e) {
            String[] stringArray = new String[]{defaultTitle, null};
            return stringArray;
        }
        finally {
            EntityUtils.consume((HttpEntity)entity);
        }
    }

    private static String decodeHtmlText(String body) {
        body = body.replaceAll("<[^>]*>", "\n");
        body = body.replaceAll("\n+", "\n");
        body = body.replaceAll("&lt;", "<");
        body = body.replaceAll("&gt;", ">");
        body = body.replaceAll("&nbsp;", " ");
        body = body.replaceAll("&amp;", "&");
        return body;
    }

    public ResponseException(String message) {
        super(message);
        this.full = this.firstMessage(message);
        this.msg = this.trimMessage(this.full);
    }

    public ResponseException(String message, Throwable cause) {
        super(message, cause);
        this.full = this.firstMessage(message);
        this.msg = this.trimMessage(this.full);
    }

    public ResponseException(Throwable cause) {
        super(cause);
        if (cause instanceof ResponseException) {
            this.full = this.firstMessage(((ResponseException)cause).getLongMessage());
            this.msg = this.trimMessage(this.full);
        } else {
            this.full = this.firstMessage(cause.toString());
            this.msg = this.trimMessage(this.full);
        }
    }

    public ResponseException(String message, String stack) {
        super(stack == null ? message : stack);
        this.full = this.firstMessage(message);
        this.msg = this.trimMessage(this.full);
    }

    public abstract int getStatusCode();

    public Header[] getResponseHeaders() {
        return this.headers.toArray(new Header[this.headers.size()]);
    }

    public ResponseException addLdpConstraint(String target) {
        return this.addLink(target, "http://www.w3.org/ns/ldp#constrainedBy");
    }

    public ResponseException addLink(String target, String rel) {
        return this.addHeader("Link", "<" + target + ">;rel=\"" + rel + "\"");
    }

    public ResponseException addHeader(String name, String value) {
        this.headers.add((Header)new BasicHeader(name, value));
        return this;
    }

    @Override
    public String toString() {
        return this.getDetailMessage();
    }

    public String getShortMessage() {
        return this.msg;
    }

    public String getLongMessage() {
        return this.full;
    }

    public String getDetailMessage() {
        return super.getMessage();
    }

    private String firstMessage(String msg) {
        if (msg == null) {
            Throwable cause = this.getCause();
            msg = cause == null ? this.getClass().getName() : cause.getClass().getName();
        }
        if (msg.contains("\r\n\tat ")) {
            msg = msg.substring(0, msg.indexOf("\r\n\tat "));
        }
        if (msg.contains("\n\tat ")) {
            msg = msg.substring(0, msg.indexOf("\n\tat "));
        }
        return this.trimExceptionClass(msg, this);
    }

    private String trimMessage(String msg) {
        if (msg.contains("\r")) {
            msg = msg.substring(0, msg.indexOf("\r"));
        }
        if (msg.contains("\n")) {
            msg = msg.substring(0, msg.indexOf("\n"));
        }
        if (msg.length() > 192) {
            msg = msg.substring(0, 136) + "..." + msg.substring(msg.length() - 53);
        }
        return msg;
    }

    private String trimExceptionClass(String msg, Throwable cause) {
        if (cause == null) {
            return msg;
        }
        String prefix = cause.getClass().getName() + ": ";
        if (msg.startsWith(prefix)) {
            msg = msg.substring(prefix.length());
        }
        return this.trimExceptionClass(msg, cause.getCause());
    }
}

