/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import javax.xml.stream.XMLEventReader;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.openrdf.http.object.fluid.Fluid;
import org.openrdf.http.object.fluid.FluidException;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.io.ChannelUtil;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public abstract class AbstractFluid
implements Fluid {
    public String toString() {
        String systemId = this.getSystemId();
        if (systemId == null) {
            return String.valueOf(this.getFluidType());
        }
        return systemId + " " + String.valueOf(this.getFluidType());
    }

    @Override
    public final String toChannelMedia(String ... media) {
        return this.toMedia(new FluidType((Type)((Object)ReadableByteChannel.class), media));
    }

    @Override
    public final ReadableByteChannel asChannel(String ... media) throws IOException, FluidException {
        return (ReadableByteChannel)this.as(new FluidType((Type)((Object)ReadableByteChannel.class), media));
    }

    @Override
    public final void transferTo(WritableByteChannel out, String ... media) throws IOException, FluidException {
        ChannelUtil.transfer(this.asChannel(media), out);
    }

    @Override
    public final String toStreamMedia(String ... media) {
        return this.toMedia(new FluidType((Type)((Object)InputStream.class), media));
    }

    @Override
    public final InputStream asStream(String ... media) throws IOException, FluidException {
        return (InputStream)this.as(new FluidType((Type)((Object)InputStream.class), media));
    }

    @Override
    public final void streamTo(OutputStream out, String ... media) throws IOException, FluidException {
        ChannelUtil.transfer(this.asStream(media), out);
    }

    @Override
    public final String toReaderMedia(String ... media) {
        return this.toMedia(new FluidType((Type)((Object)Reader.class), media));
    }

    @Override
    public final Reader asReader(String ... media) throws IOException, FluidException {
        return (Reader)this.as(new FluidType((Type)((Object)Reader.class), media));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void writeTo(Writer writer, String ... media) throws IOException, FluidException {
        Reader reader = this.asReader(media);
        if (reader == null) {
            return;
        }
        try {
            int read;
            char[] cbuf = new char[1024];
            while ((read = reader.read(cbuf)) >= 0) {
                writer.write(cbuf, 0, read);
            }
        }
        finally {
            reader.close();
        }
    }

    @Override
    public final String toStringMedia(String ... media) {
        return this.toMedia(new FluidType((Type)((Object)String.class), media));
    }

    @Override
    public final String asString(String ... media) throws IOException, FluidException {
        return (String)this.as(new FluidType((Type)((Object)String.class), media));
    }

    @Override
    public String toCharSequenceMedia(String ... media) {
        return this.toMedia(new FluidType((Type)((Object)CharSequence.class), media));
    }

    @Override
    public CharSequence asCharSequence(String ... media) throws IOException, FluidException {
        return (CharSequence)this.as(new FluidType((Type)((Object)CharSequence.class), media));
    }

    @Override
    public final String toHttpEntityMedia(String ... media) {
        return this.toMedia(new FluidType((Type)((Object)HttpEntity.class), media));
    }

    @Override
    public final HttpEntity asHttpEntity(String ... media) throws IOException, FluidException {
        return (HttpEntity)this.as(new FluidType((Type)((Object)HttpEntity.class), media));
    }

    @Override
    public final String toHttpResponseMedia(String ... media) {
        return this.toMedia(new FluidType((Type)((Object)HttpResponse.class), media));
    }

    @Override
    public final HttpResponse asHttpResponse(String ... media) throws IOException, FluidException {
        return (HttpResponse)this.as(new FluidType((Type)((Object)HttpResponse.class), media));
    }

    @Override
    public final String toXMLEventReaderMedia(String ... media) {
        return this.toMedia(new FluidType((Type)((Object)XMLEventReader.class), media));
    }

    @Override
    public final XMLEventReader asXMLEventReader(String ... media) throws IOException, FluidException {
        return (XMLEventReader)this.as(new FluidType((Type)((Object)XMLEventReader.class), media));
    }

    @Override
    public final String toDocumentMedia(String ... media) {
        return this.toMedia(new FluidType((Type)((Object)Document.class), media));
    }

    @Override
    public final Document asDocument(String ... media) throws IOException, FluidException {
        return (Document)this.as(new FluidType((Type)((Object)Document.class), media));
    }

    @Override
    public final String toDocumentFragmentMedia(String ... media) {
        return this.toMedia(new FluidType((Type)((Object)DocumentFragment.class), media));
    }

    @Override
    public final DocumentFragment asDocumentFragment(String ... media) throws IOException, FluidException {
        return (DocumentFragment)this.as(new FluidType((Type)((Object)DocumentFragment.class), media));
    }

    @Override
    public String toElementMedia(String ... media) {
        return this.toMedia(new FluidType((Type)((Object)Element.class), media));
    }

    @Override
    public Element asElement(String ... media) throws IOException, FluidException {
        return (Element)this.as(new FluidType((Type)((Object)Element.class), media));
    }

    @Override
    public final String toMedia(Type gtype, String ... media) {
        return this.toMedia(new FluidType(gtype, media));
    }

    @Override
    public final Object as(Type gtype, String ... media) throws IOException, FluidException {
        return this.as(new FluidType(gtype, media));
    }
}

