/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import org.openrdf.http.object.fluid.AbstractFluid;
import org.openrdf.http.object.fluid.Fluid;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidException;
import org.openrdf.http.object.fluid.FluidType;

class ChannelFluid
extends AbstractFluid {
    private final Fluid fluid;
    private final FluidBuilder builder;

    public ChannelFluid(Fluid fluid, FluidBuilder builder) {
        assert (fluid != null);
        assert (builder != null);
        this.fluid = fluid;
        this.builder = builder;
    }

    @Override
    public FluidType getFluidType() {
        return this.fluid.getFluidType();
    }

    @Override
    public String getSystemId() {
        return this.fluid.getSystemId();
    }

    @Override
    public String toString() {
        return this.fluid.toString();
    }

    @Override
    public void asVoid() throws IOException, FluidException {
        this.fluid.asVoid();
    }

    @Override
    public String toMedia(FluidType ftype) {
        String ret = this.fluid.toMedia(ftype);
        if (ret != null) {
            return ret;
        }
        String[] cmt = this.getChannelMedia(ftype.media());
        return this.builder.media(cmt).toMedia(ftype);
    }

    @Override
    public Object as(FluidType ftype) throws IOException, FluidException {
        try {
            if (this.fluid.toMedia(ftype) != null) {
                return this.fluid.as(ftype);
            }
            String[] cmt = this.getChannelMedia(ftype.media());
            ReadableByteChannel in = this.fluid.asChannel(cmt);
            return this.builder.channel(in, this.fluid.getSystemId(), cmt).as(ftype);
        }
        catch (RuntimeException e) {
            throw this.handle(e);
        }
        catch (Error e) {
            throw this.handle(e);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
        catch (FluidException e) {
            throw this.handle(e);
        }
    }

    private String[] getChannelMedia(String[] media) {
        String channelMedia = this.fluid.toChannelMedia(media);
        if (channelMedia != null) {
            return new String[]{channelMedia};
        }
        return this.getFluidType().media();
    }

    protected <E extends Throwable> E handle(E cause) throws IOException, FluidException {
        try {
            this.asVoid();
            return cause;
        }
        catch (RuntimeException e) {
            e.initCause(cause);
            throw e;
        }
        catch (Error e) {
            e.initCause(cause);
            throw e;
        }
        catch (FluidException e) {
            e.initCause(cause);
            throw e;
        }
        catch (IOException e) {
            e.initCause(cause);
            throw e;
        }
    }
}

