/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid;

import java.io.IOException;
import org.openrdf.http.object.fluid.AbstractFluid;
import org.openrdf.http.object.fluid.Fluid;
import org.openrdf.http.object.fluid.FluidException;
import org.openrdf.http.object.fluid.FluidType;

class FluidArray
extends AbstractFluid {
    private final Fluid[] fluids;
    private final Fluid sample;
    private final String systemId;
    private final FluidType ftype;

    public FluidArray(Fluid[] fluids, Fluid nil, String systemId, FluidType ftype) {
        assert (fluids != null);
        this.fluids = fluids;
        this.sample = fluids.length > 0 ? fluids[0] : nil;
        this.systemId = systemId;
        this.ftype = ftype;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public FluidType getFluidType() {
        return this.ftype;
    }

    @Override
    public void asVoid() throws IOException, FluidException {
        for (Fluid fluid : this.fluids) {
            fluid.asVoid();
        }
    }

    @Override
    public String toMedia(FluidType ftype) {
        if (ftype.isCollection()) {
            return this.sample.toMedia(ftype.component());
        }
        return this.sample.toMedia(ftype);
    }

    @Override
    public Object as(FluidType ftype) throws IOException, FluidException {
        if (ftype.isCollection()) {
            Object[] result = new Object[this.fluids.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.fluids[i].as(ftype.component());
            }
            return ftype.castArray(result);
        }
        if (this.fluids.length == 0) {
            return null;
        }
        for (Fluid fluid : this.fluids) {
            if (fluid == this.sample) continue;
            fluid.asVoid();
        }
        return this.sample.as(ftype);
    }
}

