/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openrdf.annotations.Iri;
import org.openrdf.http.object.exceptions.BadRequest;
import org.openrdf.http.object.fluid.AbstractFluid;
import org.openrdf.http.object.fluid.ChannelFluid;
import org.openrdf.http.object.fluid.Consumer;
import org.openrdf.http.object.fluid.Fluid;
import org.openrdf.http.object.fluid.FluidArray;
import org.openrdf.http.object.fluid.FluidException;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.Producer;
import org.openrdf.http.object.io.ChannelUtil;
import org.openrdf.repository.object.ObjectFactory;
import org.openrdf.repository.object.ObjectService;

public class FluidBuilder {
    private final List<Consumer<?>> consumers;
    List<Producer> producers;
    private final ObjectFactory of;

    public FluidBuilder(List<Consumer<?>> consumers, List<Producer> producers, ObjectService service) {
        assert (consumers != null);
        assert (producers != null);
        this.consumers = consumers;
        this.producers = producers;
        this.of = service == null ? null : service.createObjectFactory();
    }

    public ObjectFactory getObjectFactory() {
        return this.of;
    }

    public boolean isDatatype(Class<?> type) {
        if (this.of == null) {
            return false;
        }
        return this.of.isDatatype(type);
    }

    public boolean isConcept(Class<?> component) {
        if (this.of == null) {
            return false;
        }
        if (component.isAnnotationPresent(Iri.class)) {
            return true;
        }
        for (Annotation ann : component.getAnnotations()) {
            for (Method m : ann.annotationType().getDeclaredMethods()) {
                if (!m.isAnnotationPresent(Iri.class)) continue;
                return true;
            }
        }
        return this.of.isNamedConcept(component);
    }

    public boolean isConsumable(Type gtype, String ... media) {
        return this.isConsumable(new FluidType(gtype, media));
    }

    public boolean isConsumable(FluidType mtype) {
        Consumer<?> writer;
        if (mtype.isCollection() && (writer = this.findRawWriter(mtype.component())) != null) {
            return true;
        }
        return this.findRawWriter(mtype) != null;
    }

    public Fluid media(String ... media) {
        return this.channel(null, null, media);
    }

    public Fluid nil(FluidType ftype) {
        return this.consume(null, null, ftype);
    }

    public Fluid uri(String uri, String base) {
        return this.consume(uri, base, new FluidType((Type)((Object)String.class), "text/uri-list"));
    }

    public Fluid channel(final ReadableByteChannel in, final String base, final String ... mediaTypes) {
        final FluidType inType = new FluidType((Type)((Object)ReadableByteChannel.class), mediaTypes);
        return new AbstractFluid(){

            @Override
            public String getSystemId() {
                return base;
            }

            @Override
            public FluidType getFluidType() {
                return inType;
            }

            @Override
            public String toString() {
                return String.valueOf(in) + " " + Arrays.toString(mediaTypes);
            }

            @Override
            public void asVoid() throws IOException {
                if (in != null) {
                    in.close();
                }
            }

            @Override
            public String toMedia(FluidType ftype) {
                FluidType outType = inType.as(ftype);
                Producer reader = this.findReader(outType);
                if (reader == null) {
                    return null;
                }
                return outType.preferred();
            }

            @Override
            public Object as(FluidType ftype) throws IOException, FluidException {
                try {
                    Charset charset = inType.getCharset();
                    FluidType outType = inType.as(ftype);
                    Producer reader = this.findRawReader(outType);
                    if (reader != null) {
                        return reader.produce(outType, in, charset, base, FluidBuilder.this);
                    }
                    if (outType.isCollection() && (reader = this.findRawReader(outType.component())) == null && in == null) {
                        return outType.castSet(Collections.emptySet());
                    }
                    if (reader == null && !outType.isPrimitive() && in == null) {
                        return null;
                    }
                    if (reader == null) {
                        throw new BadRequest("Cannot read " + inType + " into " + ftype);
                    }
                    Object o = reader.produce(outType.component(), in, charset, base, FluidBuilder.this);
                    return outType.castComponent(o);
                }
                catch (Error e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (FluidException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw this.fluidException(e);
                }
            }

            private Producer findReader(FluidType mtype) {
                Producer reader = this.findRawReader(mtype);
                if (reader != null) {
                    return reader;
                }
                if (mtype.isCollection()) {
                    return this.findRawReader(mtype.component());
                }
                return null;
            }

            private Producer findRawReader(FluidType mtype) {
                for (Producer reader : FluidBuilder.this.producers) {
                    if (!reader.isProducable(mtype, FluidBuilder.this)) continue;
                    return reader;
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private FluidException fluidException(Exception e) throws IOException, FluidException {
                try {
                    Throwable cause = e;
                    while (cause instanceof IOException) {
                        cause = cause.getCause();
                    }
                    if (cause == null) {
                        throw (IOException)e;
                    }
                    FluidException fluidException = new FluidException(e);
                    return fluidException;
                }
                finally {
                    try {
                        this.asVoid();
                    }
                    catch (RuntimeException v) {
                        v.initCause(e);
                        throw v;
                    }
                    catch (Error v) {
                        v.initCause(e);
                        throw v;
                    }
                    catch (IOException v) {
                        v.initCause(e);
                        throw v;
                    }
                }
            }
        };
    }

    public Fluid stream(InputStream in, String base, String ... media) {
        return this.channel(ChannelUtil.newChannel(in), base, media);
    }

    public Fluid read(Readable in, String base, String ... media) {
        return this.consume(in, base, (Type)((Object)Readable.class), media);
    }

    public Fluid consume(Object result, String base, Type gtype, String ... media) {
        return this.consume(result, base, new FluidType(gtype, media));
    }

    public Fluid consume(Object result, String base, FluidType mtype) {
        Consumer<?> writer = this.findRawWriter(mtype);
        if (writer == null && mtype.isCollection() && (writer = this.findRawWriter(mtype.component())) != null) {
            Object array = mtype.toArray(result);
            int len = Array.getLength(array);
            Fluid[] fluids = new Fluid[len];
            for (int i = 0; i < len; ++i) {
                fluids[i] = this.consume(Array.get(array, i), base, mtype.component());
            }
            return new FluidArray(fluids, this.nil(mtype.component()), base, mtype);
        }
        if (writer == null) {
            throw new BadRequest("Cannot write " + result + " into " + mtype);
        }
        return new ChannelFluid(writer.consume(result, base, mtype, this), this);
    }

    private Consumer<?> findRawWriter(FluidType mtype) {
        for (Consumer<?> w : this.consumers) {
            if (!w.isConsumable(mtype, this)) continue;
            return w;
        }
        return null;
    }
}

