/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import org.openrdf.http.object.fluid.Consumer;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.Producer;
import org.openrdf.http.object.fluid.consumers.BooleanMessageWriter;
import org.openrdf.http.object.fluid.consumers.BufferedImageWriter;
import org.openrdf.http.object.fluid.consumers.ByteArrayMessageWriter;
import org.openrdf.http.object.fluid.consumers.ByteArrayStreamMessageWriter;
import org.openrdf.http.object.fluid.consumers.DOMMessageWriter;
import org.openrdf.http.object.fluid.consumers.DatatypeWriter;
import org.openrdf.http.object.fluid.consumers.DocumentFragmentMessageWriter;
import org.openrdf.http.object.fluid.consumers.FormMapMessageWriter;
import org.openrdf.http.object.fluid.consumers.FormStringMessageWriter;
import org.openrdf.http.object.fluid.consumers.GraphMessageWriter;
import org.openrdf.http.object.fluid.consumers.HttpEntityWriter;
import org.openrdf.http.object.fluid.consumers.HttpMessageWriter;
import org.openrdf.http.object.fluid.consumers.InputStreamBodyWriter;
import org.openrdf.http.object.fluid.consumers.ModelMessageWriter;
import org.openrdf.http.object.fluid.consumers.PrimitiveBodyWriter;
import org.openrdf.http.object.fluid.consumers.ReadableBodyWriter;
import org.openrdf.http.object.fluid.consumers.ReadableByteChannelBodyWriter;
import org.openrdf.http.object.fluid.consumers.StringBodyWriter;
import org.openrdf.http.object.fluid.consumers.TupleMessageWriter;
import org.openrdf.http.object.fluid.consumers.URIListWriter;
import org.openrdf.http.object.fluid.consumers.VoidWriter;
import org.openrdf.http.object.fluid.consumers.XMLEventMessageWriter;
import org.openrdf.http.object.fluid.producers.BooleanMessageReader;
import org.openrdf.http.object.fluid.producers.BufferedImageReader;
import org.openrdf.http.object.fluid.producers.ByteArrayMessageReader;
import org.openrdf.http.object.fluid.producers.ByteArrayStreamMessageReader;
import org.openrdf.http.object.fluid.producers.DOMMessageReader;
import org.openrdf.http.object.fluid.producers.DatatypeReader;
import org.openrdf.http.object.fluid.producers.DocumentFragmentMessageReader;
import org.openrdf.http.object.fluid.producers.FormMapMessageReader;
import org.openrdf.http.object.fluid.producers.FormStringMessageReader;
import org.openrdf.http.object.fluid.producers.GraphMessageReader;
import org.openrdf.http.object.fluid.producers.HttpEntityReader;
import org.openrdf.http.object.fluid.producers.HttpMessageReader;
import org.openrdf.http.object.fluid.producers.InputStreamBodyReader;
import org.openrdf.http.object.fluid.producers.ModelMessageReader;
import org.openrdf.http.object.fluid.producers.PrimitiveBodyReader;
import org.openrdf.http.object.fluid.producers.ReadableBodyReader;
import org.openrdf.http.object.fluid.producers.ReadableByteChannelBodyReader;
import org.openrdf.http.object.fluid.producers.StringBodyReader;
import org.openrdf.http.object.fluid.producers.TupleMessageReader;
import org.openrdf.http.object.fluid.producers.VoidReader;
import org.openrdf.http.object.fluid.producers.XMLEventMessageReader;
import org.openrdf.http.object.fluid.producers.base.URIListReader;
import org.openrdf.repository.object.ObjectService;
import org.openrdf.repository.object.ObjectServiceImpl;
import org.openrdf.repository.object.exceptions.ObjectStoreConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluidFactory {
    private static final FluidFactory instance = new FluidFactory();
    private final Logger logger = LoggerFactory.getLogger(FluidFactory.class);
    private List<Consumer<?>> consumers = new ArrayList();
    private List<Producer> producers = new ArrayList<Producer>();
    private ObjectService service;

    public static FluidFactory getInstance() {
        return instance;
    }

    private void init() {
        this.consumers.add(new BooleanMessageWriter());
        this.consumers.add(new ModelMessageWriter());
        this.consumers.add(new GraphMessageWriter());
        this.consumers.add(new TupleMessageWriter());
        this.consumers.add(new DatatypeWriter());
        this.consumers.add(new StringBodyWriter());
        this.consumers.add(new VoidWriter());
        this.consumers.add(new PrimitiveBodyWriter());
        this.consumers.add(new HttpMessageWriter());
        this.consumers.add(new InputStreamBodyWriter());
        this.consumers.add(new ReadableBodyWriter());
        this.consumers.add(new ReadableByteChannelBodyWriter());
        this.consumers.add(new XMLEventMessageWriter());
        this.consumers.add(new ByteArrayMessageWriter());
        this.consumers.add(new ByteArrayStreamMessageWriter());
        this.consumers.add(new FormMapMessageWriter());
        this.consumers.add(new FormStringMessageWriter());
        this.consumers.add(new HttpEntityWriter());
        this.consumers.add(new BufferedImageWriter());
        this.consumers.add(URIListWriter.RDF_URI);
        this.consumers.add(URIListWriter.NET_URL);
        this.consumers.add(URIListWriter.NET_URI);
        try {
            this.consumers.add(new DocumentFragmentMessageWriter());
            this.consumers.add(new DOMMessageWriter());
        }
        catch (TransformerConfigurationException e) {
            throw new AssertionError((Object)e);
        }
        this.producers.add(URIListReader.RDF_URI);
        this.producers.add(URIListReader.NET_URL);
        this.producers.add(URIListReader.NET_URI);
        this.producers.add(new ModelMessageReader());
        this.producers.add(new GraphMessageReader());
        this.producers.add(new TupleMessageReader());
        this.producers.add(new BooleanMessageReader());
        this.producers.add(new DatatypeReader());
        this.producers.add(new StringBodyReader());
        this.producers.add(new VoidReader());
        this.producers.add(new PrimitiveBodyReader());
        this.producers.add(new FormMapMessageReader());
        this.producers.add(new FormStringMessageReader());
        this.producers.add(new HttpMessageReader());
        this.producers.add(new InputStreamBodyReader());
        this.producers.add(new ReadableBodyReader());
        this.producers.add(new ReadableByteChannelBodyReader());
        this.producers.add(new XMLEventMessageReader());
        this.producers.add(new ByteArrayMessageReader());
        this.producers.add(new ByteArrayStreamMessageReader());
        this.producers.add(new DOMMessageReader());
        this.producers.add(new DocumentFragmentMessageReader());
        this.producers.add(new HttpEntityReader());
        this.producers.add(new BufferedImageReader());
    }

    public FluidBuilder builder() {
        return new FluidBuilder(this.consumers, this.producers, this.getObjectService());
    }

    private synchronized ObjectService getObjectService() {
        if (this.service == null) {
            try {
                this.setObjectService((ObjectService)new ObjectServiceImpl());
            }
            catch (ObjectStoreConfigException e) {
                this.logger.warn(e.toString(), (Throwable)e);
            }
        }
        return this.service;
    }

    private void setObjectService(ObjectService service) {
        this.service = service;
    }

    static {
        instance.init();
    }
}

