/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid;

import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import org.openrdf.http.object.fluid.GenericType;
import org.openrdf.http.object.fluid.MediaType;
import org.w3c.dom.Document;

public class FluidType
extends GenericType {
    private static final FluidType XML = new FluidType((Type)((Object)Document.class), "application/xml", "text/xml", "image/xml", "text/xsl", "application/xml-external-parsed-entity", "text/xml-external-parsed-entity");
    private final TreeSet<MediaType> mediaTypes = new TreeSet<MediaType>(new MediaTypeComparator());

    public FluidType(Type gtype, String ... media) {
        super(gtype);
        if (media != null && media.length == 0) {
            media = new String[]{"*/*"};
        }
        if (media == null) {
            media = new String[]{};
        }
        HashSet<String> set = new HashSet<String>();
        for (String m : media) {
            MediaType mediaType;
            if (m == null || set.contains(m) || set.contains((mediaType = MediaType.valueOf(m)).toExternal())) continue;
            set.add(mediaType.toExternal());
            this.mediaTypes.add(mediaType.multiply(1.0 - (double)this.mediaTypes.size() / 1000000.0));
        }
    }

    private FluidType(Type gtype, Collection<MediaType> media, boolean nonEmpty) {
        super(gtype);
        assert (media != null);
        HashSet<String> set = new HashSet<String>();
        for (MediaType mediaType : media) {
            if (set.contains(mediaType.toExternal())) continue;
            set.add(mediaType.toExternal());
            this.mediaTypes.add(mediaType.multiply(1.0 - (double)this.mediaTypes.size() / 1000000.0));
        }
    }

    @Override
    public String toString() {
        String list = Arrays.toString(this.media());
        return super.toString() + " " + list.substring(1, list.length() - 1);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.mediaTypes.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FluidType other = (FluidType)obj;
        return this.mediaTypes.equals(other.mediaTypes);
    }

    public String[] media() {
        String[] media = new String[this.mediaTypes.size()];
        Iterator<MediaType> iter = this.mediaTypes.iterator();
        for (int i = 0; i < media.length; ++i) {
            media[i] = iter.next().toExternal();
        }
        return media;
    }

    public String preferred() {
        if (this.mediaTypes.isEmpty()) {
            return null;
        }
        for (MediaType mime : this.mediaTypes) {
            if ("*".equals(mime.getPrimaryType()) || "*".equals(mime.getSubType())) continue;
            return mime.toExternal();
        }
        return null;
    }

    public Charset getCharset() {
        for (MediaType m : this.mediaTypes) {
            String name = m.getParameter("charset");
            if (name == null) continue;
            return Charset.forName(name);
        }
        return null;
    }

    public boolean isText() {
        return this.is("text/*");
    }

    public boolean is(String ... acceptable) {
        return this.is(new FluidType(this.asType(), acceptable));
    }

    public boolean is(FluidType ftype) {
        if (!this.is(ftype.asType())) {
            return false;
        }
        for (MediaType accept : ftype.mediaTypes) {
            for (MediaType mime : this.mediaTypes) {
                if (!mime.match(accept) || accept.getSubType().contains("+") && !mime.getSubType().contains("+")) continue;
                return true;
            }
        }
        return false;
    }

    public double getQuality() {
        double max = Double.MIN_VALUE;
        for (MediaType mime : this.mediaTypes) {
            double q = mime.getQuality();
            if (!(q > max)) continue;
            max = q;
        }
        return max;
    }

    public FluidType as(Type type) {
        return new FluidType(type, this.mediaTypes, true);
    }

    public FluidType as(String ... acceptable) {
        if (acceptable == null) {
            return new FluidType(this.asType(), (String[])null);
        }
        if (acceptable.length == 0 || this.mediaTypes.isEmpty()) {
            return this;
        }
        return this.as(this.asType(), acceptable);
    }

    public FluidType as(Type type, String ... acceptable) {
        return this.as(new FluidType(type, acceptable));
    }

    public FluidType as(FluidType acceptable) {
        ArrayList<MediaType> combined = new ArrayList<MediaType>(this.mediaTypes.size());
        for (MediaType accept : acceptable.mediaTypes) {
            for (MediaType mime : this.mediaTypes) {
                if (!mime.match(accept)) continue;
                combined.add(mime.combine(accept));
            }
        }
        if (combined.isEmpty()) {
            return new FluidType(acceptable.asType(), (String[])null);
        }
        return new FluidType(acceptable.asType(), combined, true);
    }

    public boolean isXML() {
        return this.is(XML.as(this.asType()));
    }

    public FluidType asXML() {
        return this.as(XML.as(this.asType()));
    }

    public FluidType key(String ... mediaType) {
        return new FluidType(this.key().asType(), mediaType);
    }

    @Override
    public FluidType component() {
        return new FluidType(super.component().asType(), this.mediaTypes, true);
    }

    public FluidType component(String ... mediaType) {
        return new FluidType(super.component().asType(), mediaType);
    }

    private final class MediaTypeComparator
    implements Comparator<MediaType> {
        private MediaTypeComparator() {
        }

        @Override
        public int compare(MediaType o1, MediaType o2) {
            Double q1 = o1.getQuality();
            Double q2 = o2.getQuality();
            int compare = q2.compareTo(q1);
            if (compare != 0) {
                return compare;
            }
            if (!"*".equals(o1.getPrimaryType()) && "*".equals(o2.getPrimaryType())) {
                return -1;
            }
            if ("*".equals(o1.getPrimaryType()) && !"*".equals(o2.getPrimaryType())) {
                return 1;
            }
            if (!"*".equals(o1.getSubType()) && "*".equals(o2.getSubType())) {
                return -1;
            }
            if ("*".equals(o1.getSubType()) && !"*".equals(o2.getSubType())) {
                return 1;
            }
            if (!"*".equals(o1.getSubType()) && "*".equals(o2.getSubType())) {
                return -1;
            }
            if (o1.getSubType().contains("+") && !o2.getSubType().contains("+")) {
                return -1;
            }
            if (!o1.getSubType().contains("+") && o2.getSubType().contains("+")) {
                return 1;
            }
            return o1.toExternal().compareTo(o2.toExternal());
        }
    }
}

