/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GenericType {
    private final Type gtype;

    public GenericType(Type genericType) {
        assert (genericType != null);
        this.gtype = genericType;
    }

    public Class<?> asClass() {
        return this.toClass(this.gtype);
    }

    public final Type asType() {
        return this.gtype;
    }

    public String toString() {
        return this.gtype.toString();
    }

    public int hashCode() {
        return this.gtype.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericType other = (GenericType)obj;
        return this.gtype.equals(other.gtype);
    }

    public boolean isAnnotation() {
        return this.asClass().isAnnotation();
    }

    public boolean isEnum() {
        return this.asClass().isEnum();
    }

    public boolean isInterface() {
        return this.asClass().isInterface();
    }

    public boolean isPrimitive() {
        return this.asClass().isPrimitive();
    }

    public boolean is(Type type) {
        return this.toClass(type).equals(this.asClass());
    }

    public boolean isMap() {
        return Map.class.equals(this.asClass());
    }

    public boolean isSet() {
        return Set.class.equals(this.asClass());
    }

    public boolean isList() {
        return List.class.equals(this.asClass());
    }

    public boolean isArray() {
        return this.asClass().isArray();
    }

    public boolean isUnknown() {
        return Object.class.equals(this.asClass());
    }

    public boolean isCollection() {
        return this.isSetOrArray() || this.is((Type)((Object)List.class)) || this.is((Type)((Object)Collection.class));
    }

    public boolean isSetOrArray() {
        return this.isSet() || this.isArray();
    }

    public boolean isSetOrArrayOf(Type componentType) {
        return this.isSetOf(componentType) || this.isArrayOf(componentType);
    }

    public boolean isOrIsSetOf(Type type) {
        if (this.is(type)) {
            return true;
        }
        if (!this.isSet()) {
            return false;
        }
        return this.component().is(type);
    }

    public GenericType key() {
        if (this.isArray()) {
            return new GenericType(Integer.TYPE);
        }
        if (this.gtype instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)this.gtype;
            Type[] args = ptype.getActualTypeArguments();
            return new GenericType(args[0]);
        }
        return new GenericType((Type)((Object)Object.class));
    }

    public GenericType component() {
        if (this.isArray()) {
            return new GenericType(this.asClass().getComponentType());
        }
        if (this.gtype instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)this.gtype;
            Type[] args = ptype.getActualTypeArguments();
            return new GenericType(args[args.length - 1]);
        }
        return new GenericType((Type)((Object)Object.class));
    }

    public Object toArray(Object obj) {
        if (obj == null) {
            return Array.newInstance(this.component().asClass(), 0);
        }
        if (this.isArray()) {
            return this.castArray(obj);
        }
        if (this.isCollection()) {
            Collection set = (Collection)obj;
            Object[] array = (Object[])Array.newInstance(this.component().asClass(), set.size());
            return set.toArray(array);
        }
        Object array = Array.newInstance(this.asClass(), 1);
        Array.set(array, 0, obj);
        return array;
    }

    public Object nil() {
        if (this.isArray()) {
            return this.cast(Array.newInstance(this.component().asClass(), 0));
        }
        if (this.isList()) {
            return this.cast(Collections.emptyList());
        }
        if (this.isSet() || this.isCollection()) {
            return this.cast(Collections.emptySet());
        }
        if (this.isMap()) {
            return this.cast(Collections.emptyMap());
        }
        return null;
    }

    public Object cast(Object obj) {
        if (obj == null) {
            return this.nil();
        }
        try {
            if (this.asClass().isPrimitive()) {
                return obj;
            }
            return this.asClass().cast(obj);
        }
        catch (ClassCastException e) {
            String msg = "Cannot cast " + obj + " to " + this.asClass().getSimpleName();
            ClassCastException cce = new ClassCastException(msg);
            cce.initCause(e);
            throw cce;
        }
    }

    public Object castComponent(Object obj) {
        if (obj == null) {
            return this.nil();
        }
        if (this.isArray()) {
            Object result = Array.newInstance(this.component().asClass(), 1);
            Array.set(result, 0, obj);
            return this.cast(result);
        }
        if (this.isList()) {
            return this.cast(Collections.singletonList(obj));
        }
        if (this.isSet() || this.isCollection()) {
            return this.cast(Collections.singleton(obj));
        }
        return this.cast(obj);
    }

    public Object castSet(Set<?> set) {
        return this.castCollection(set);
    }

    public Object castArray(Object ar) {
        if (ar == null || Array.getLength(ar) == 0) {
            return this.nil();
        }
        int len = Array.getLength(ar);
        if (this.isArray()) {
            if (this.asClass().isAssignableFrom(ar.getClass())) {
                return this.cast(ar);
            }
            Object result = Array.newInstance(this.component().asClass(), len);
            for (int i = 0; i < len; ++i) {
                Array.set(result, i, Array.get(ar, i));
            }
            return this.cast(result);
        }
        if (this.isSet()) {
            LinkedHashSet<Object> set = new LinkedHashSet<Object>(len);
            for (int i = 0; i < len; ++i) {
                set.add(Array.get(ar, i));
            }
            return this.cast(set);
        }
        if (this.isList() || this.isCollection()) {
            ArrayList<Object> set = new ArrayList<Object>(len);
            for (int i = 0; i < len; ++i) {
                set.add(Array.get(ar, i));
            }
            return this.cast(set);
        }
        return this.cast(Array.get(ar, 0));
    }

    public Object castMap(Map<Object, Collection<Object>> map) {
        if (map == null || map.isEmpty()) {
            return this.nil();
        }
        if (this.isMap()) {
            GenericType keyType = this.key();
            GenericType valueType = this.component();
            LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
            for (Map.Entry<Object, Collection<Object>> e : map.entrySet()) {
                Object key = keyType.cast(e.getKey());
                Object value = valueType.castCollection(e.getValue());
                result.put(key, value);
            }
            return this.cast(result);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (Map.Entry<Object, Collection<Object>> e : map.entrySet()) {
            list.addAll(e.getValue());
        }
        return this.castCollection(list);
    }

    public Iterator<?> iteratorOf(Object obj) {
        if (this.isArray()) {
            int len = Array.getLength(obj);
            ArrayList<Object> list = new ArrayList<Object>(len);
            for (int i = 0; i < len; ++i) {
                list.add(Array.get(obj, i));
            }
            return list.iterator();
        }
        if (this.isCollection()) {
            return ((Set)obj).iterator();
        }
        return Collections.singleton(obj).iterator();
    }

    private boolean isSetOf(Type componentType) {
        if (!this.isSet()) {
            return false;
        }
        return this.component().is(componentType);
    }

    private boolean isArrayOf(Type componentType) {
        if (!this.isArray()) {
            return false;
        }
        return this.component().is(componentType);
    }

    private Object castCollection(Collection<?> list) {
        if (list == null || list.isEmpty()) {
            return this.nil();
        }
        if (this.isArray()) {
            int len = list.size();
            Object result = Array.newInstance(this.component().asClass(), len);
            Iterator<?> iter = list.iterator();
            for (int i = 0; i < len; ++i) {
                Array.set(result, i, iter.next());
            }
            return this.cast(result);
        }
        if (this.isSet()) {
            if (list instanceof Set) {
                return this.cast(list);
            }
            return this.cast(new LinkedHashSet(list));
        }
        if (this.isList()) {
            if (list instanceof List) {
                return this.cast(list);
            }
            return this.cast(new ArrayList(list));
        }
        if (this.isCollection()) {
            return this.cast(list);
        }
        Iterator<?> iter = list.iterator();
        return this.cast(iter.next());
    }

    private Class<?> toClass(Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType atype = (GenericArrayType)type;
            Class<?> componentType = this.toClass(atype.getGenericComponentType());
            return Array.newInstance(this.toClass(componentType), 0).getClass();
        }
        if (type instanceof ParameterizedType) {
            return this.toClass(((ParameterizedType)type).getRawType());
        }
        return Object.class;
    }
}

