/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid;

import java.io.Serializable;
import java.util.Enumeration;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;

public class MediaType
implements Serializable {
    private static final long serialVersionUID = 2653020125056041502L;
    private static final MediaType WILD;
    private final String normal;
    private final double quality;
    private final MimeType parsed;

    public static MediaType valueOf(String mediaType) throws IllegalArgumentException {
        try {
            if (mediaType == null || mediaType.length() == 0 || mediaType.equals("*/*") || mediaType.equals("*")) {
                return WILD;
            }
            if (mediaType.indexOf(47) < 0) {
                int dash = mediaType.indexOf(45);
                if (dash > 0) {
                    String primary = mediaType.substring(0, dash);
                    String rest = mediaType.substring(dash + 1);
                    String lexical = primary + "/" + rest;
                    return new MediaType(lexical, new MimeType(lexical));
                }
                int colon = mediaType.indexOf(59);
                if (colon > 0) {
                    String primary = mediaType.substring(0, colon);
                    String param = mediaType.substring(colon);
                    String lexical = primary + "/*" + param;
                    return new MediaType(lexical, new MimeType(lexical));
                }
                String lexical = mediaType + "/*";
                return new MediaType(lexical, new MimeType(mediaType, "*"));
            }
            return new MediaType(mediaType, new MimeType(mediaType));
        }
        catch (MimeTypeParseException e) {
            throw new IllegalArgumentException(e.getMessage() + ": " + mediaType);
        }
    }

    private MediaType(String media, MimeType mime) {
        double quality;
        assert (mime != null);
        String q = mime.getParameter("q");
        mime.removeParameter("q");
        double d = quality = q == null ? 1.0 : Double.valueOf(q);
        if ("*".equals(mime.getPrimaryType())) {
            quality *= 0.5;
        }
        if ("*".equals(mime.getSubType())) {
            quality *= 0.2;
        }
        if (!mime.getSubType().contains("+")) {
            quality *= 0.9999999;
        }
        this.quality = quality;
        this.parsed = mime;
        String lexical = mime.toString();
        this.normal = lexical.equals(media) ? media : lexical;
    }

    private MediaType(String media, MimeType mime, double quality) {
        this.quality = quality;
        this.parsed = mime;
        this.normal = media;
    }

    public String toString() {
        if (this.quality == 1.0) {
            return this.toExternal();
        }
        return this.normal + ";q=" + this.quality;
    }

    public String toExternal() {
        return this.normal;
    }

    public int hashCode() {
        return this.normal.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MediaType other = (MediaType)obj;
        if (!this.normal.equals(other.normal)) {
            return false;
        }
        return this.getQuality() == other.getQuality();
    }

    public String getPrimaryType() {
        return this.parsed.getPrimaryType();
    }

    public String getSubType() {
        return this.parsed.getSubType();
    }

    public String getParameter(String name) {
        return this.parsed.getParameter(name);
    }

    public String getBaseType() {
        return this.parsed.getBaseType();
    }

    public double getQuality() {
        return this.quality;
    }

    public MediaType multiply(double multiplier) {
        return new MediaType(this.normal, this.parsed, this.quality * multiplier);
    }

    public Enumeration<String> getParameterNames() {
        return this.parsed.getParameters().getNames();
    }

    public MediaType combine(MediaType accept) {
        assert (accept != null);
        if (this.toExternal().equals(accept.toExternal()) && accept.getQuality() == 1.0) {
            return this;
        }
        if (this.toExternal().equals(accept.toExternal())) {
            return this.multiply(accept.getQuality());
        }
        try {
            MimeType mime = new MimeType(this.normal);
            if ("*".equals(mime.getPrimaryType())) {
                mime.setPrimaryType(accept.getPrimaryType());
            }
            if ("*".equals(mime.getSubType())) {
                mime.setSubType(accept.getSubType());
            }
            Enumeration<String> e = accept.getParameterNames();
            while (e.hasMoreElements()) {
                String p = e.nextElement();
                assert (!"q".equals(p));
                if (mime.getParameter(p) != null) continue;
                mime.setParameter(p, accept.getParameter(p));
            }
            return new MediaType(mime.toString(), mime, this.getQuality() * accept.getQuality());
        }
        catch (MimeTypeParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean match(String rawdata) throws IllegalArgumentException {
        return this.match(MediaType.valueOf(rawdata));
    }

    public boolean match(MediaType accept) {
        if (accept == null) {
            return false;
        }
        if (this.equals(accept)) {
            return true;
        }
        if (this.parsed.match(accept.parsed)) {
            return this.isParametersAcceptable(accept);
        }
        if ("*".equals(this.getPrimaryType())) {
            return this.isSubTypeAcceptable(accept);
        }
        if ("*".equals(accept.getPrimaryType())) {
            return this.isSubTypeAcceptable(accept);
        }
        if (!this.getPrimaryType().equals(accept.getPrimaryType())) {
            return false;
        }
        return this.isSubTypeAcceptable(accept);
    }

    private boolean isSubTypeAcceptable(MediaType accept) {
        if ("*".equals(this.getSubType())) {
            return this.isParametersAcceptable(accept);
        }
        if ("*".equals(accept.getSubType())) {
            return this.isParametersAcceptable(accept);
        }
        if (this.getSubType().endsWith("+" + accept.getSubType())) {
            return this.isParametersAcceptable(accept);
        }
        return false;
    }

    private boolean isParametersAcceptable(MediaType accept) {
        Enumeration<String> names = accept.getParameterNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            if ("q".equals(name) || this.getParameter(name) == null || accept.getParameter(name).equals(this.getParameter(name))) continue;
            return false;
        }
        return true;
    }

    static {
        try {
            WILD = new MediaType("*/*", new MimeType("*/*"), new MediaType("*/*", new MimeType("*/*")).getQuality());
        }
        catch (MimeTypeParseException e) {
            throw new AssertionError((Object)e);
        }
    }
}

