/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import javax.xml.stream.XMLEventReader;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.openrdf.http.object.fluid.AbstractFluid;
import org.openrdf.http.object.fluid.FluidException;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.io.ChannelUtil;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class Vapor
extends AbstractFluid {
    @Override
    public final String toMedia(FluidType ftype) {
        if (ftype.is((Type)((Object)ReadableByteChannel.class))) {
            return this.toChannelMedia(ftype);
        }
        if (ftype.is((Type)((Object)InputStream.class))) {
            return this.toStreamMedia(ftype);
        }
        if (ftype.is((Type)((Object)Reader.class)) || ftype.is((Type)((Object)Readable.class))) {
            return this.toReaderMedia(ftype);
        }
        if (ftype.is((Type)((Object)String.class)) || ftype.is((Type)((Object)CharSequence.class))) {
            return this.toCharSequenceMedia(ftype);
        }
        if (ftype.is((Type)((Object)HttpEntity.class))) {
            return this.toHttpEntityMedia(ftype);
        }
        if (ftype.is((Type)((Object)HttpResponse.class))) {
            return this.toHttpResponseMedia(ftype);
        }
        if (ftype.is((Type)((Object)XMLEventReader.class))) {
            return this.toXMLEventReaderMedia(ftype);
        }
        if (ftype.is((Type)((Object)Document.class)) || ftype.is((Type)((Object)Node.class))) {
            return this.toDocumentMedia(ftype);
        }
        if (ftype.is((Type)((Object)DocumentFragment.class))) {
            return this.toDocumentFragmentMedia(ftype);
        }
        if (ftype.is((Type)((Object)Element.class))) {
            return this.toElementMedia(ftype);
        }
        return null;
    }

    @Override
    public final Object as(FluidType ftype) throws IOException, FluidException {
        try {
            if (ftype.is((Type)((Object)ReadableByteChannel.class))) {
                return this.asChannel(ftype);
            }
            if (ftype.is((Type)((Object)InputStream.class))) {
                return this.asStream(ftype);
            }
            if (ftype.is((Type)((Object)Reader.class)) || ftype.is((Type)((Object)Readable.class))) {
                return this.asReader(ftype);
            }
            if (ftype.is((Type)((Object)CharSequence.class))) {
                return this.asCharSequence(ftype);
            }
            if (ftype.is((Type)((Object)String.class))) {
                CharSequence cs = this.asCharSequence(ftype);
                if (cs == null) {
                    return null;
                }
                return cs.toString();
            }
            if (ftype.is((Type)((Object)HttpEntity.class))) {
                return this.asHttpEntity(ftype);
            }
            if (ftype.is((Type)((Object)HttpResponse.class))) {
                return this.asHttpResponse(ftype);
            }
            if (ftype.is((Type)((Object)XMLEventReader.class))) {
                return this.asXMLEventReader(ftype);
            }
            if (ftype.is((Type)((Object)Document.class)) || ftype.is((Type)((Object)Node.class))) {
                return this.asDocument(ftype);
            }
            if (ftype.is((Type)((Object)DocumentFragment.class))) {
                return this.asDocumentFragment(ftype);
            }
            if (ftype.is((Type)((Object)Element.class))) {
                return this.asElement(ftype);
            }
            this.asVoid();
            return null;
        }
        catch (Error e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (FluidException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.fluidException(e);
        }
    }

    protected String toChannelMedia(FluidType media) {
        return null;
    }

    protected ReadableByteChannel asChannel(FluidType media) throws Exception {
        this.asVoid();
        return null;
    }

    protected void transferTo(WritableByteChannel out, FluidType media) throws Exception {
        ChannelUtil.transfer(this.asChannel(media), out);
    }

    protected String toStreamMedia(FluidType media) {
        return null;
    }

    protected InputStream asStream(FluidType media) throws Exception {
        this.asVoid();
        return null;
    }

    protected void streamTo(OutputStream out, FluidType media) throws Exception {
        ChannelUtil.transfer(this.asStream(media), out);
    }

    protected String toReaderMedia(FluidType media) {
        return null;
    }

    protected Reader asReader(FluidType media) throws Exception {
        this.asVoid();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeTo(Writer writer, FluidType media) throws Exception {
        Reader reader = this.asReader(media);
        if (reader == null) {
            return;
        }
        try {
            int read;
            char[] cbuf = new char[1024];
            while ((read = reader.read(cbuf)) >= 0) {
                writer.write(cbuf, 0, read);
            }
        }
        finally {
            reader.close();
        }
    }

    protected String toCharSequenceMedia(FluidType media) {
        return null;
    }

    protected CharSequence asCharSequence(FluidType media) throws Exception {
        this.asVoid();
        return null;
    }

    protected String toHttpEntityMedia(FluidType media) {
        return null;
    }

    protected HttpEntity asHttpEntity(FluidType media) throws Exception {
        this.asVoid();
        return null;
    }

    protected String toHttpResponseMedia(FluidType media) {
        return null;
    }

    protected HttpResponse asHttpResponse(FluidType media) throws Exception {
        this.asVoid();
        return null;
    }

    protected String toXMLEventReaderMedia(FluidType media) {
        return null;
    }

    protected XMLEventReader asXMLEventReader(FluidType media) throws Exception {
        this.asVoid();
        return null;
    }

    protected String toDocumentMedia(FluidType media) {
        return null;
    }

    protected Document asDocument(FluidType media) throws Exception {
        this.asVoid();
        return null;
    }

    protected String toDocumentFragmentMedia(FluidType media) {
        return null;
    }

    protected DocumentFragment asDocumentFragment(FluidType media) throws Exception {
        this.asVoid();
        return null;
    }

    protected String toElementMedia(FluidType media) {
        return null;
    }

    protected Element asElement(FluidType media) throws Exception {
        this.asVoid();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FluidException fluidException(Exception e) throws IOException, FluidException {
        try {
            Throwable cause;
            if (e == null) {
                FluidException fluidException = null;
                return fluidException;
            }
            for (cause = e; cause instanceof IOException && cause != e; cause = cause.getCause()) {
            }
            if (cause == null) {
                throw (IOException)e;
            }
            FluidException fluidException = new FluidException(e);
            return fluidException;
        }
        finally {
            try {
                this.asVoid();
            }
            catch (RuntimeException v) {
                v.initCause(e);
                throw v;
            }
            catch (Error v) {
                v.initCause(e);
                throw v;
            }
            catch (FluidException v) {
                v.initCause(e);
                throw v;
            }
            catch (IOException v) {
                v.initCause(e);
                throw v;
            }
        }
    }
}

