/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.consumers;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.openrdf.http.object.fluid.Consumer;
import org.openrdf.http.object.fluid.Fluid;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.Vapor;
import org.openrdf.http.object.io.ChannelUtil;
import org.openrdf.http.object.io.ProducerStream;

public class BufferedImageWriter
implements Consumer<BufferedImage> {
    private static final String[] WRITER_MIME_TYPES = ImageIO.getWriterMIMETypes();

    @Override
    public boolean isConsumable(FluidType ftype, FluidBuilder builder) {
        if (!BufferedImage.class.isAssignableFrom(ftype.asClass())) {
            return false;
        }
        return ftype.is(WRITER_MIME_TYPES);
    }

    @Override
    public Fluid consume(final BufferedImage result, final String base, final FluidType ftype, FluidBuilder builder) {
        return new Vapor(){

            @Override
            public String getSystemId() {
                return base;
            }

            @Override
            public FluidType getFluidType() {
                return ftype;
            }

            @Override
            public void asVoid() {
            }

            @Override
            protected String toChannelMedia(FluidType media) {
                return ftype.as(media).preferred();
            }

            @Override
            protected ReadableByteChannel asChannel(final FluidType media) throws IOException {
                if (result == null) {
                    return null;
                }
                return ChannelUtil.newChannel(new ProducerStream(new ProducerStream.OutputProducer(){

                    @Override
                    public void produce(OutputStream out) throws IOException {
                        try {
                            this.streamTo(out, ftype.as(this.toChannelMedia(media)));
                        }
                        finally {
                            out.close();
                        }
                    }

                    public String toString() {
                        return result.toString();
                    }
                }));
            }

            @Override
            protected String toStreamMedia(FluidType media) {
                return this.toChannelMedia(media);
            }

            @Override
            protected InputStream asStream(FluidType media) throws IOException {
                if (result == null) {
                    return null;
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
                try {
                    this.streamTo((OutputStream)baos, media);
                }
                finally {
                    baos.close();
                }
                return new ByteArrayInputStream(baos.toByteArray());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void streamTo(OutputStream out, FluidType media) throws IOException {
                if (result == null) {
                    return;
                }
                String type = ftype.as(media).preferred();
                Iterator<ImageWriter> iter = ImageIO.getImageWritersByMIMEType(type);
                if (!iter.hasNext()) {
                    throw new IOException("No Image writer found for " + type);
                }
                ImageOutputStream stream = null;
                try {
                    stream = ImageIO.createImageOutputStream(out);
                }
                catch (IOException e) {
                    throw new IIOException("Can't create output stream!", e);
                }
                try {
                    ImageWriter writer = iter.next();
                    writer.setOutput(stream);
                    try {
                        writer.write(result);
                    }
                    catch (IOException e) {
                        writer.abort();
                        throw e;
                    }
                    finally {
                        writer.dispose();
                    }
                }
                finally {
                    stream.close();
                }
            }

            @Override
            public String toString() {
                return String.valueOf(result);
            }
        };
    }
}

