/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.consumers;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import org.apache.http.HttpEntity;
import org.openrdf.http.object.fluid.Consumer;
import org.openrdf.http.object.fluid.Fluid;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.Vapor;
import org.openrdf.http.object.helpers.ReadableHttpEntityChannel;
import org.openrdf.http.object.io.ChannelUtil;

public class ByteArrayMessageWriter
implements Consumer<byte[]> {
    @Override
    public boolean isConsumable(FluidType mtype, FluidBuilder builder) {
        return mtype.isArray() && mtype.component().is(Byte.TYPE);
    }

    @Override
    public Fluid consume(final byte[] result, final String base, final FluidType ftype, FluidBuilder builder) {
        return new Vapor(){

            @Override
            public String getSystemId() {
                return base;
            }

            @Override
            public FluidType getFluidType() {
                return ftype;
            }

            @Override
            public void asVoid() {
            }

            @Override
            protected String toChannelMedia(FluidType media) {
                return ftype.as(media).preferred();
            }

            @Override
            protected ReadableByteChannel asChannel(FluidType media) throws IOException {
                return ChannelUtil.newChannel(result);
            }

            @Override
            protected String toHttpEntityMedia(FluidType media) {
                return this.toChannelMedia(media);
            }

            @Override
            protected HttpEntity asHttpEntity(FluidType media) throws IOException {
                String mediaType = this.toChannelMedia(media);
                long size = result == null ? 0 : result.length;
                return new ReadableHttpEntityChannel(mediaType, size, this.asChannel(media));
            }

            @Override
            public String toString() {
                return String.valueOf(result);
            }
        };
    }
}

