/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.consumers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.channels.ReadableByteChannel;
import org.apache.http.HttpEntity;
import org.openrdf.http.object.fluid.Consumer;
import org.openrdf.http.object.fluid.Fluid;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.Vapor;
import org.openrdf.http.object.helpers.ReadableHttpEntityChannel;
import org.openrdf.http.object.io.ChannelUtil;

public class ByteArrayStreamMessageWriter
implements Consumer<ByteArrayOutputStream> {
    @Override
    public boolean isConsumable(FluidType mtype, FluidBuilder builder) {
        if (!mtype.is((Type)((Object)ByteArrayOutputStream.class))) {
            return false;
        }
        return mtype.is("application/*");
    }

    @Override
    public Fluid consume(final ByteArrayOutputStream result, final String base, final FluidType ftype, FluidBuilder builder) {
        return new Vapor(){

            @Override
            public String getSystemId() {
                return base;
            }

            @Override
            public FluidType getFluidType() {
                return ftype;
            }

            @Override
            public void asVoid() {
            }

            @Override
            protected String toChannelMedia(FluidType media) {
                return ftype.as(media).preferred();
            }

            @Override
            protected ReadableByteChannel asChannel(FluidType media) throws IOException {
                if (result == null) {
                    return ChannelUtil.emptyChannel();
                }
                return ChannelUtil.newChannel(result.toByteArray());
            }

            @Override
            protected String toHttpEntityMedia(FluidType media) {
                return this.toChannelMedia(media);
            }

            @Override
            protected HttpEntity asHttpEntity(FluidType media) throws IOException {
                String mediaType = this.toChannelMedia(media);
                long size = result == null ? 0 : result.size();
                return new ReadableHttpEntityChannel(mediaType, size, this.asChannel(media));
            }

            @Override
            public String toString() {
                return String.valueOf(result);
            }
        };
    }
}

