/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.consumers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openrdf.OpenRDFException;
import org.openrdf.http.object.fluid.Consumer;
import org.openrdf.http.object.fluid.Fluid;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.Vapor;
import org.openrdf.http.object.fluid.helpers.DocumentFactory;
import org.openrdf.http.object.io.ChannelUtil;
import org.openrdf.http.object.io.ProducerStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DOMMessageWriter
implements Consumer<Node> {
    static final DocumentFactory docFactory = DocumentFactory.newInstance();
    TransformerFactory factory = TransformerFactory.newInstance();

    @Override
    public boolean isConsumable(FluidType mtype, FluidBuilder builder) {
        Class<?> type = mtype.asClass();
        return mtype.isXML() && Node.class.isAssignableFrom(type);
    }

    @Override
    public Fluid consume(final Node node, final String base, final FluidType ftype, FluidBuilder builder) {
        return new Vapor(){

            @Override
            public String getSystemId() {
                return base;
            }

            @Override
            public FluidType getFluidType() {
                return ftype;
            }

            @Override
            public void asVoid() {
            }

            @Override
            protected String toChannelMedia(FluidType media) {
                FluidType xml = ftype.as(media);
                String mimeType = xml.preferred();
                if (mimeType != null && mimeType.startsWith("text/") && !mimeType.contains("charset=")) {
                    Charset charset = xml.getCharset();
                    if (charset == null) {
                        charset = Charset.defaultCharset();
                    }
                    return mimeType + ";charset=" + charset.name();
                }
                return mimeType;
            }

            @Override
            protected ReadableByteChannel asChannel(final FluidType media) throws IOException {
                if (node == null) {
                    return null;
                }
                return ChannelUtil.newChannel(new ProducerStream(new ProducerStream.OutputProducer(){

                    @Override
                    public void produce(OutputStream out) throws IOException {
                        try {
                            this.streamTo(out, media);
                        }
                        catch (TransformerException e) {
                            throw new IOException(e);
                        }
                        finally {
                            out.close();
                        }
                    }

                    public String toString() {
                        return String.valueOf(node);
                    }
                }));
            }

            @Override
            protected void transferTo(WritableByteChannel out, FluidType media) throws IOException, TransformerException {
                this.streamTo(ChannelUtil.newOutputStream(out), media);
            }

            @Override
            protected String toStreamMedia(FluidType media) {
                return this.toChannelMedia(media);
            }

            @Override
            protected InputStream asStream(final FluidType media) throws IOException {
                if (node == null) {
                    return null;
                }
                return new ProducerStream(new ProducerStream.OutputProducer(){

                    @Override
                    public void produce(OutputStream out) throws IOException {
                        try {
                            this.streamTo(out, media);
                        }
                        catch (TransformerException e) {
                            throw new IOException(e);
                        }
                        finally {
                            out.close();
                        }
                    }

                    public String toString() {
                        return String.valueOf(node);
                    }
                });
            }

            @Override
            protected void streamTo(OutputStream out, FluidType media) throws TransformerException {
                if (node == null) {
                    return;
                }
                Charset charset = ftype.as(this.toChannelMedia(media)).getCharset();
                if (charset == null) {
                    charset = Charset.defaultCharset();
                }
                DOMSource source = new DOMSource(node, base);
                StreamResult result = new StreamResult(out);
                Transformer transformer = DOMMessageWriter.this.factory.newTransformer();
                transformer.setOutputProperty("encoding", charset.name());
                ErrorCatcher listener = new ErrorCatcher();
                transformer.setErrorListener(listener);
                transformer.transform(source, result);
                if (listener.isFatal()) {
                    throw listener.getFatalError();
                }
            }

            @Override
            protected String toDocumentMedia(FluidType media) {
                return ftype.as(media).preferred();
            }

            @Override
            protected Document asDocument(FluidType media) throws OpenRDFException, IOException, XMLStreamException, ParserConfigurationException, SAXException, TransformerConfigurationException, TransformerException {
                if (node == null) {
                    return null;
                }
                if (node instanceof Document) {
                    return (Document)node;
                }
                if (node instanceof DocumentFragment) {
                    NodeList nodes = node.getChildNodes();
                    Document doc = docFactory.newDocument();
                    if (nodes.getLength() == 1 && node.getFirstChild().getNodeType() == 1) {
                        doc.appendChild(doc.importNode(node.getFirstChild(), true));
                    } else {
                        Element root = doc.createElement("root");
                        root.appendChild(doc.importNode(node, true));
                        doc.appendChild(root);
                    }
                    return doc;
                }
                Document doc = docFactory.newDocument();
                doc.appendChild(doc.importNode(node, true));
                return doc;
            }

            @Override
            protected String toDocumentFragmentMedia(FluidType media) {
                return ftype.as(media).preferred();
            }

            @Override
            protected DocumentFragment asDocumentFragment(FluidType media) throws OpenRDFException, IOException, XMLStreamException, ParserConfigurationException, SAXException, TransformerConfigurationException, TransformerException {
                if (node == null) {
                    return null;
                }
                if (node instanceof DocumentFragment) {
                    return (DocumentFragment)node;
                }
                if (node instanceof Document) {
                    Document doc = (Document)node;
                    DocumentFragment frag = doc.createDocumentFragment();
                    frag.appendChild(doc.getDocumentElement());
                    return frag;
                }
                Document doc = node.getOwnerDocument();
                DocumentFragment frag = doc.createDocumentFragment();
                frag.appendChild(node);
                return frag;
            }

            @Override
            protected String toElementMedia(FluidType media) {
                return ftype.as(media).preferred();
            }

            @Override
            protected Element asElement(FluidType media) throws OpenRDFException, IOException, XMLStreamException, ParserConfigurationException, SAXException, TransformerConfigurationException, TransformerException {
                if (node instanceof Element) {
                    return (Element)node;
                }
                Document doc = this.asDocument(media);
                if (doc == null) {
                    return null;
                }
                return doc.getDocumentElement();
            }

            @Override
            public String toString() {
                return String.valueOf(node);
            }
        };
    }

    static class ErrorCatcher
    implements ErrorListener {
        private Logger logger = LoggerFactory.getLogger(ErrorCatcher.class);
        private TransformerException fatal;

        ErrorCatcher() {
        }

        public boolean isFatal() {
            return this.fatal != null;
        }

        public TransformerException getFatalError() {
            return this.fatal;
        }

        @Override
        public void error(TransformerException exception) {
            this.logger.warn(exception.toString(), (Throwable)exception);
        }

        @Override
        public void fatalError(TransformerException exception) {
            if (this.fatal == null) {
                this.fatal = exception;
            }
            this.logger.error(exception.toString(), (Throwable)exception);
        }

        @Override
        public void warning(TransformerException exception) {
            this.logger.info(exception.toString(), (Throwable)exception);
        }
    }
}

