/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.consumers;

import java.lang.reflect.Type;
import java.util.Set;
import org.openrdf.http.object.fluid.Consumer;
import org.openrdf.http.object.fluid.Fluid;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.consumers.StringBodyWriter;
import org.openrdf.repository.object.RDFObject;

public class DatatypeWriter
implements Consumer<Object> {
    private StringBodyWriter delegate = new StringBodyWriter();

    @Override
    public boolean isConsumable(FluidType mtype, FluidBuilder builder) {
        Class<?> type = mtype.asClass();
        if (Set.class.equals(type)) {
            return false;
        }
        if (Object.class.equals(type)) {
            return false;
        }
        if (RDFObject.class.isAssignableFrom(type)) {
            return false;
        }
        if (type.isArray() && Byte.TYPE.equals(type.getComponentType())) {
            return false;
        }
        if (!this.delegate.isConsumable(mtype.as((Type)((Object)String.class)), builder)) {
            return false;
        }
        return builder.isDatatype(type);
    }

    @Override
    public Fluid consume(Object result, String base, FluidType ftype, FluidBuilder builder) {
        String label = this.asString(result, builder);
        return this.delegate.consume(label, base, ftype.as((Type)((Object)String.class)), builder);
    }

    private String asString(Object result, FluidBuilder builder) {
        if (result == null) {
            return null;
        }
        return builder.getObjectFactory().createLiteral(result).getLabel();
    }
}

