/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.consumers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.openrdf.OpenRDFException;
import org.openrdf.http.object.fluid.Consumer;
import org.openrdf.http.object.fluid.Fluid;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.Vapor;
import org.openrdf.http.object.fluid.helpers.DocumentFactory;
import org.openrdf.http.object.io.ChannelUtil;
import org.openrdf.http.object.io.ProducerStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DocumentFragmentMessageWriter
implements Consumer<DocumentFragment> {
    private static final String XSL_FRAGMENT = "<stylesheet version='1.0' xmlns='http://www.w3.org/1999/XSL/Transform'><template match='/root'><copy-of select='*|text()|comment()'/></template></stylesheet>";
    private TransformerFactory factory = TransformerFactory.newInstance();
    DocumentFactory docFactory;
    private Templates fragments;

    public DocumentFragmentMessageWriter() throws TransformerConfigurationException {
        StringReader reader = new StringReader(XSL_FRAGMENT);
        this.fragments = this.factory.newTemplates(new StreamSource(reader));
        this.docFactory = DocumentFactory.newInstance();
    }

    @Override
    public boolean isConsumable(FluidType mtype, FluidBuilder builder) {
        return mtype.isXML() && DocumentFragment.class.isAssignableFrom(mtype.asClass());
    }

    @Override
    public Fluid consume(final DocumentFragment node, final String base, final FluidType ftype, FluidBuilder builder) {
        return new Vapor(){

            @Override
            public String getSystemId() {
                return base;
            }

            @Override
            public FluidType getFluidType() {
                return ftype;
            }

            @Override
            public void asVoid() {
            }

            @Override
            protected String toChannelMedia(FluidType media) {
                FluidType ftype1 = ftype.as(media);
                String mimeType = ftype1.preferred();
                if (mimeType != null && mimeType.startsWith("text/") && !mimeType.contains("charset=")) {
                    Charset charset = ftype1.getCharset();
                    if (charset == null) {
                        charset = Charset.defaultCharset();
                    }
                    return mimeType + ";charset=" + charset.name();
                }
                return mimeType;
            }

            @Override
            protected ReadableByteChannel asChannel(final FluidType media) throws IOException {
                if (node == null) {
                    return null;
                }
                return ChannelUtil.newChannel(new ProducerStream(new ProducerStream.OutputProducer(){

                    @Override
                    public void produce(OutputStream out) throws IOException {
                        try {
                            this.streamTo(out, media);
                        }
                        catch (TransformerException e) {
                            throw new IOException(e);
                        }
                        catch (ParserConfigurationException e) {
                            throw new IOException(e);
                        }
                        finally {
                            out.close();
                        }
                    }

                    public String toString() {
                        return String.valueOf(node);
                    }
                }));
            }

            @Override
            protected void transferTo(WritableByteChannel out, FluidType media) throws TransformerException, ParserConfigurationException {
                this.streamTo(ChannelUtil.newOutputStream(out), media);
            }

            @Override
            protected String toStreamMedia(FluidType media) {
                return this.toChannelMedia(media);
            }

            @Override
            protected InputStream asStream(final FluidType media) throws IOException {
                if (node == null) {
                    return null;
                }
                return new ProducerStream(new ProducerStream.OutputProducer(){

                    @Override
                    public void produce(OutputStream out) throws IOException {
                        try {
                            this.streamTo(out, media);
                        }
                        catch (TransformerException e) {
                            throw new IOException(e);
                        }
                        catch (ParserConfigurationException e) {
                            throw new IOException(e);
                        }
                        finally {
                            out.close();
                        }
                    }

                    public String toString() {
                        return String.valueOf(node);
                    }
                });
            }

            @Override
            protected void streamTo(OutputStream out, FluidType media) throws TransformerException, ParserConfigurationException {
                if (node == null) {
                    return;
                }
                Charset charset = ftype.as(this.toChannelMedia(media)).getCharset();
                if (charset == null) {
                    charset = Charset.defaultCharset();
                }
                DOMSource source = DocumentFragmentMessageWriter.this.createSource(node, base);
                StreamResult result1 = new StreamResult(out);
                Transformer transformer = DocumentFragmentMessageWriter.this.createTransformer(node);
                transformer.setOutputProperty("encoding", charset.name());
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                ErrorCatcher listener = new ErrorCatcher();
                transformer.setErrorListener(listener);
                transformer.transform(source, result1);
                if (listener.isFatal()) {
                    throw listener.getFatalError();
                }
            }

            @Override
            protected String toDocumentMedia(FluidType media) {
                return ftype.as(media).preferred();
            }

            @Override
            protected Document asDocument(FluidType media) throws OpenRDFException, IOException, XMLStreamException, ParserConfigurationException, SAXException, TransformerConfigurationException, TransformerException {
                if (node == null) {
                    return null;
                }
                NodeList nodes = node.getChildNodes();
                Document doc = DocumentFragmentMessageWriter.this.docFactory.newDocument();
                if (nodes.getLength() == 1 && node.getFirstChild().getNodeType() == 1) {
                    doc.appendChild(doc.importNode(node.getFirstChild(), true));
                } else {
                    Element root = doc.createElement("root");
                    root.appendChild(doc.importNode(node, true));
                    doc.appendChild(root);
                }
                return doc;
            }

            @Override
            protected String toDocumentFragmentMedia(FluidType media) {
                return ftype.as(media).preferred();
            }

            @Override
            protected DocumentFragment asDocumentFragment(FluidType media) throws OpenRDFException, IOException, XMLStreamException, ParserConfigurationException, SAXException, TransformerConfigurationException, TransformerException {
                return node;
            }

            @Override
            protected String toElementMedia(FluidType media) {
                return ftype.as(media).preferred();
            }

            @Override
            protected Element asElement(FluidType media) throws OpenRDFException, IOException, XMLStreamException, ParserConfigurationException, SAXException, TransformerConfigurationException, TransformerException {
                if (node == null) {
                    return null;
                }
                NodeList nodes = node.getChildNodes();
                if (nodes.getLength() == 1 && node.getFirstChild() instanceof Element) {
                    return (Element)node.getFirstChild();
                }
                Document doc = this.asDocument(media);
                if (doc == null) {
                    return null;
                }
                return doc.getDocumentElement();
            }

            @Override
            public String toString() {
                return String.valueOf(node);
            }
        };
    }

    DOMSource createSource(DocumentFragment node, String base) throws ParserConfigurationException {
        if (node == null) {
            return new DOMSource(this.docFactory.newDocument(), base);
        }
        if (node.getChildNodes().getLength() == 1) {
            return new DOMSource(node.getFirstChild(), base);
        }
        Document doc = this.docFactory.newDocument();
        Element root = doc.createElement("root");
        root.appendChild(doc.importNode(node, true));
        return new DOMSource(root, base);
    }

    Transformer createTransformer(DocumentFragment node) throws TransformerConfigurationException {
        if (node.getChildNodes().getLength() == 1) {
            return this.factory.newTransformer();
        }
        return this.fragments.newTransformer();
    }

    static class ErrorCatcher
    implements ErrorListener {
        private Logger logger = LoggerFactory.getLogger(ErrorCatcher.class);
        private TransformerException fatal;

        ErrorCatcher() {
        }

        public boolean isFatal() {
            return this.fatal != null;
        }

        public TransformerException getFatalError() {
            return this.fatal;
        }

        @Override
        public void error(TransformerException exception) {
            this.logger.warn(exception.toString(), (Throwable)exception);
        }

        @Override
        public void fatalError(TransformerException exception) {
            if (this.fatal == null) {
                this.fatal = exception;
            }
            this.logger.error(exception.toString(), (Throwable)exception);
        }

        @Override
        public void warning(TransformerException exception) {
            this.logger.info(exception.toString(), (Throwable)exception);
        }
    }
}

