/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.consumers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import org.openrdf.http.object.fluid.Consumer;
import org.openrdf.http.object.fluid.Fluid;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidException;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.Vapor;
import org.openrdf.http.object.io.ChannelUtil;

public class FormMapMessageWriter
implements Consumer<Map<String, Object>> {
    @Override
    public boolean isConsumable(FluidType mtype, FluidBuilder delegate) {
        if (!mtype.isMap()) {
            return false;
        }
        if (!mtype.key().isUnknown() && !delegate.isConsumable(mtype.key("text/plain"))) {
            return false;
        }
        FluidType vt = mtype.component("text/plain");
        if (vt.isSetOrArray() ? !delegate.isConsumable(vt.component()) : !vt.isUnknown() && !delegate.isConsumable(vt)) {
            return false;
        }
        return mtype.is(this.getMediaType());
    }

    @Override
    public Fluid consume(final Map<String, Object> result, final String base, final FluidType ftype, final FluidBuilder builder) {
        return new Vapor(){

            @Override
            public String getSystemId() {
                return base;
            }

            @Override
            public FluidType getFluidType() {
                return ftype;
            }

            @Override
            public void asVoid() {
            }

            @Override
            protected String toChannelMedia(FluidType media) {
                return ftype.as(FormMapMessageWriter.this.getMediaType()).as(media).preferred();
            }

            @Override
            protected ReadableByteChannel asChannel(FluidType media) throws UnsupportedEncodingException, IOException, FluidException {
                return FormMapMessageWriter.this.write(ftype.as(FormMapMessageWriter.this.getMediaType()), result, base, builder);
            }

            @Override
            public String toString() {
                return String.valueOf(result);
            }
        };
    }

    String getMediaType() {
        return "application/x-www-form-urlencoded";
    }

    ReadableByteChannel write(FluidType mtype, Map<String, Object> result, String base, FluidBuilder builder) throws UnsupportedEncodingException, IOException, FluidException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        this.writeTo(mtype, result, base, builder, out, 1024);
        return ChannelUtil.newChannel(out.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTo(FluidType mtype, Map<String, Object> result, String base, FluidBuilder builder, OutputStream out, int bufSize) throws UnsupportedEncodingException, IOException, FluidException {
        FluidType vctype;
        FluidType vtype;
        Charset charset = mtype.getCharset();
        if (charset == null) {
            charset = Charset.forName("ISO-8859-1");
        }
        if ((vtype = mtype.component("text/plain")).isUnknown()) {
            vtype = vtype.as((Type)((Object)String[].class));
        }
        if ((vctype = vtype).isSetOrArray()) {
            vctype = vctype.component();
        }
        OutputStreamWriter writer = new OutputStreamWriter(out, charset);
        try {
            if (result == null) {
                return;
            }
            boolean first = true;
            for (Map.Entry<String, Object> e : result.entrySet()) {
                if (e.getKey() == null) continue;
                String name = this.enc(this.writeTo(mtype.key("text/plain"), e.getKey(), base, builder));
                Iterator<?> iter = vtype.iteratorOf(e.getValue());
                if (first) {
                    first = false;
                } else {
                    ((Writer)writer).append("&");
                }
                ((Writer)writer).append(name);
                while (iter.hasNext()) {
                    Object value = iter.next();
                    if (value != null) {
                        String str = this.writeTo(vctype, value, base, builder);
                        ((Writer)writer).append("=").append(this.enc(str));
                    }
                    if (!iter.hasNext()) continue;
                    ((Writer)writer).append("&").append(name);
                }
            }
        }
        finally {
            ((Writer)writer).close();
        }
    }

    private String enc(String value) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeTo(FluidType mtype, Object value, String base, FluidBuilder delegate) throws IOException, FluidException {
        if (mtype.isUnknown() && value != null) {
            mtype = mtype.as(value.getClass());
        }
        ReadableByteChannel in = delegate.consume(value, base, mtype).asChannel("text/plain;charset=ISO-8859-1");
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            ChannelUtil.transfer(in, (OutputStream)out);
            String string = out.toString("ISO-8859-1");
            return string;
        }
        finally {
            in.close();
        }
    }
}

