/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.consumers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.http.HttpEntity;
import org.openrdf.OpenRDFException;
import org.openrdf.http.object.fluid.Consumer;
import org.openrdf.http.object.fluid.Fluid;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.Vapor;
import org.openrdf.http.object.helpers.ReadableHttpEntityChannel;
import org.openrdf.http.object.io.ChannelUtil;
import org.xml.sax.SAXException;

public class FormStringMessageWriter
implements Consumer<CharSequence> {
    private static final String FORM_URLENCODED = "application/x-www-form-urlencoded";

    @Override
    public boolean isConsumable(FluidType mtype, FluidBuilder builder) {
        if (!CharSequence.class.isAssignableFrom(mtype.asClass())) {
            return false;
        }
        return mtype.is(FORM_URLENCODED);
    }

    @Override
    public Fluid consume(final CharSequence result, final String base, final FluidType ftype, FluidBuilder builder) {
        return new Vapor(){

            @Override
            public String getSystemId() {
                return base;
            }

            @Override
            public FluidType getFluidType() {
                return ftype;
            }

            @Override
            public void asVoid() {
            }

            @Override
            protected String toChannelMedia(FluidType media) {
                return ftype.as(FormStringMessageWriter.FORM_URLENCODED).as(media).preferred();
            }

            @Override
            protected ReadableByteChannel asChannel(FluidType media) throws IOException, OpenRDFException, XMLStreamException, TransformerException, ParserConfigurationException {
                return FormStringMessageWriter.this.write(ftype.as(FormStringMessageWriter.FORM_URLENCODED), result, base);
            }

            @Override
            protected String toCharSequenceMedia(FluidType media) {
                return ftype.as(FormStringMessageWriter.FORM_URLENCODED).as(media).preferred();
            }

            @Override
            protected CharSequence asCharSequence(FluidType media) throws OpenRDFException, IOException, XMLStreamException, ParserConfigurationException, SAXException, TransformerConfigurationException, TransformerException {
                return result;
            }

            @Override
            protected String toHttpEntityMedia(FluidType media) {
                return this.toChannelMedia(media);
            }

            @Override
            protected HttpEntity asHttpEntity(FluidType media) throws IOException, OpenRDFException, XMLStreamException, TransformerException, ParserConfigurationException {
                String mediaType = this.toChannelMedia(media);
                return new ReadableHttpEntityChannel(mediaType, FormStringMessageWriter.this.getSize(ftype.as(FormStringMessageWriter.FORM_URLENCODED), result), this.asChannel(media));
            }

            @Override
            public String toString() {
                return String.valueOf(result);
            }
        };
    }

    long getSize(FluidType mtype, CharSequence result) {
        Charset charset = mtype.getCharset();
        if (charset == null) {
            return result.length();
        }
        return charset.encode(result.toString()).limit();
    }

    ReadableByteChannel write(FluidType mtype, CharSequence result, String base) throws IOException, OpenRDFException, XMLStreamException, TransformerException, ParserConfigurationException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        this.writeTo(mtype, result, base, out, 1024);
        return ChannelUtil.newChannel(out.toByteArray());
    }

    private void writeTo(FluidType mtype, CharSequence result, String base, OutputStream out, int bufSize) throws IOException, OpenRDFException, XMLStreamException, TransformerException, ParserConfigurationException {
        Charset charset = mtype.getCharset();
        if (charset == null) {
            charset = Charset.forName("ISO-8859-1");
        }
        OutputStreamWriter writer = new OutputStreamWriter(out, charset);
        ((Writer)writer).append(result);
        ((Writer)writer).flush();
    }
}

