/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.consumers;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.OpenRDFException;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.helpers.MessageWriterBase;
import org.openrdf.http.object.io.TurtleStreamWriterFactory;
import org.openrdf.model.Literal;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RDFWriterFactory;
import org.openrdf.rio.RDFWriterRegistry;

public class GraphMessageWriter
extends MessageWriterBase<RDFFormat, RDFWriterFactory, GraphQueryResult> {
    private static final int SMALL = 100;

    public GraphMessageWriter() {
        super(RDFWriterRegistry.getInstance(), GraphQueryResult.class);
    }

    @Override
    public boolean isConsumable(FluidType mtype, FluidBuilder builder) {
        String mimeType = mtype.preferred();
        if (mimeType != null && mimeType.startsWith("text/plain")) {
            return false;
        }
        return super.isConsumable(mtype, builder);
    }

    @Override
    protected void close(GraphQueryResult result) throws OpenRDFException {
        result.close();
    }

    @Override
    public void writeTo(RDFWriterFactory factory, GraphQueryResult result, OutputStream out, Charset charset, String base) throws RDFHandlerException, QueryEvaluationException {
        RDFFormat rdfFormat = factory.getRDFFormat();
        RDFWriter writer = this.getWriter(out, charset, factory, base);
        writer.startRDF();
        ArrayList<Object> firstStatements = new ArrayList<Object>(100);
        boolean trimNamespaces = rdfFormat.supportsNamespaces();
        if (trimNamespaces && result != null) {
            for (int i = 0; result.hasNext() && i < 100; ++i) {
                firstStatements.add(result.next());
            }
            trimNamespaces = firstStatements.size() < 100;
            LinkedHashSet firstNamespaces = new LinkedHashSet(100);
            HashSet<String> hashSet = new HashSet<String>(100);
            for (Statement statement : firstStatements) {
                this.addNamespace((Value)statement.getSubject(), firstNamespaces);
                this.addNamespace((Value)statement.getPredicate(), firstNamespaces);
                this.addNamespace(statement.getObject(), firstNamespaces);
                this.addNamespace((Value)statement.getContext(), firstNamespaces);
            }
            for (Map.Entry entry : result.getNamespaces().entrySet()) {
                String prefix = (String)entry.getKey();
                String namespace = (String)entry.getValue();
                if (trimNamespaces && !firstNamespaces.contains(namespace)) continue;
                writer.handleNamespace(prefix, namespace);
                firstNamespaces.remove(namespace);
                hashSet.add(namespace);
            }
        }
        for (Statement statement : firstStatements) {
            writer.handleStatement(statement);
        }
        while (result != null && result.hasNext()) {
            Statement st = (Statement)result.next();
            writer.handleStatement(st);
        }
        writer.endRDF();
    }

    private RDFWriter getWriter(OutputStream out, Charset charset, RDFWriterFactory factory, String systemId) {
        if (RDFFormat.TURTLE.equals((Object)factory.getRDFFormat()) && systemId != null) {
            try {
                TurtleStreamWriterFactory tf = new TurtleStreamWriterFactory();
                if (charset == null) {
                    return tf.createWriter(out, systemId);
                }
                return tf.createWriter(new OutputStreamWriter(out, charset), systemId);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (charset == null) {
            return factory.getWriter(out);
        }
        return factory.getWriter((Writer)new OutputStreamWriter(out, charset));
    }

    private void addNamespace(Value value, Set<String> namespaces) {
        Literal lit;
        if (value instanceof URI) {
            URI uri = (URI)value;
            namespaces.add(uri.getNamespace());
        } else if (value instanceof Literal && (lit = (Literal)value).getDatatype() != null) {
            namespaces.add(lit.getDatatype().getNamespace());
        }
    }
}

